<?php if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Compra extends CI_Controller
{

    var $url = null;

    public function __construct()
    {
        parent::__construct();

        if (!Current_User::user()) {
            redirect('welcome');
        }

        $this->load->model('inventario_model');
        $this->load->model('compra_model');
        $this->load->helper('utilities');
        $this->url = 'http://189.203.201.166/oficinas/externo/com_orden_imp/';

    }

    function prueba()
    {   $data['query'] = $this->inventario_model->getInventario();
        $data['subtitulo'] = "Define los pasillos de tus areas";
        $this->load->view('main', $data);
    }

    function orden()
    {
        $data['subtitulo'] = "Ordenes";
        $data['query'] = $this->util->getDataOficina('ordenes', array('clvsucursal' => ALMACEN));
        $data['url'] = $this->url;
        //$data['js'] = "inventario/por_sucursal_js";
        $this->load->view('main', $data);
    }

    function orden_detalle($id_orden)
    {
        $data['subtitulo'] = "Detalle de la orden";
        $data['query'] = $this->util->getDataOficina('getDetalleOrdenByIDOrden', array('id_orden' => $id_orden));
        //$data['js'] = "inventario/por_sucursal_js";
        $this->load->view('main', $data);
    }

    function orden_ampliar($id_orden, $fecha_limite)
    {
        $data['subtitulo'] = "Ampliar vigencia de la orden";
        //$data['query'] = $this->util->getDataOficina('getDetalleOrdenByIDOrden', array('id_orden' => $id_orden));
        $data['js'] = "compra/orden_ampliar_js";
        $data['id_orden'] = $id_orden;
        $data['fecha_limite'] = $fecha_limite;
        $this->load->view('main', $data);
    }

    function orden_ampliar_submit()
    {
        $id_orden = $this->input->post('id_orden');
        $fecha = $this->input->post('fecha');
        $data['subtitulo'] = "Ampliar vigencia de la orden: resultado";
        $data['query'] = $this->util->getDataOficina('cambiaOrdenVigencia', array('id_orden' => $id_orden, 'fecha' => $fecha));
        $this->load->view('main', $data);
    }

}