<?php if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Facturacion extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();

        if (!Current_User::user()) {
            redirect('welcome');
        }
        
        $this->load->model('facturacion_model');
        $this->load->helper('utilities');

    }

    function generar_remision()
    {
        $data['subtitulo'] = "Generar una remisión";
        $data['js'] = "facturacion/generar_remision_js";
        $data['sucursal'] = $this->util->getSucursalCombo();
        $this->load->view('main', $data);
    }

    function posibles_remisiones()
    {
        $fecha1 = $this->input->post('fecha1');
        $fecha2 = $this->input->post('fecha2');
        $clvsucursal = $this->input->post('clvsucursal');

        $data['subtitulo'] = "Generar una remisión";
        $data['js'] = "facturacion/generar_remision_js";
        $data['query'] = $this->facturacion_model->getPosiblesRemisiones($fecha1, $fecha2, $clvsucursal);
        $data['fecha1'] = $fecha1;
        $data['fecha2'] = $fecha2;
        $this->load->view('main', $data);
    }

    function remisionar($perini, $perfin, $clvsucursal, $iva, $tiporequerimiento, $idprograma)
    {
        $validaPrecio = $this->facturacion_model->validaRemisionPrevia($perini, $perfin, $clvsucursal, $iva, $tiporequerimiento, $idprograma);

        if($validaPrecio == 0)
        {
            $this->facturacion_model->generaRemision($perini, $perfin, $clvsucursal, $iva, $tiporequerimiento, $idprograma);
            redirect('facturacion/listado_remisiones/' . $clvsucursal);
        }else
        {
            redirect('facturacion/listado_remisiones/' . $clvsucursal);
        }


    }

    function ver_remisiones()
    {
        $data['subtitulo'] = "Ver remisiones generadas";
        //$data['js'] = "catalogosweb/productos_por_secuencia_js";
        $data['sucursal'] = $this->util->getSucursalCombo();
        $this->load->view('main', $data);
    }

    function listado_remisiones($clvsucursal = null)
    {
        if($clvsucursal == null)
        {
            $clvsucursal = $this->input->post('clvsucursal');
        }

        $data['subtitulo'] = "Ver remisiones generadas";
        $data['js'] = "facturacion/listado_remisiones_js";
        $data['query'] = $this->facturacion_model->getListadoRemisiones($clvsucursal);
        $this->load->view('main', $data);
    }

    function imprimirRemision($remision, $clvsucursal)
    {
        ini_set("memory_limit","1024M");
        $data['cabeza'] = $this->facturacion_model->getRemisionCabeza($remision);
        $data['query'] = $this->facturacion_model->getRemisionDetalle($remision);
        $data['pie'] = $this->facturacion_model->getRemisionFirmas($clvsucursal);
        $this->load->view('impresiones/remision', $data);
    }

    function panorama()
    {
        $data['subtitulo'] = "Panorama";
        $data['query'] = $this->facturacion_model->getPanorama();
        //$data['js'] = "catalogosweb/productos_por_secuencia_js";
        $this->load->view('main', $data);
    }

    function eliminar_remision($remision, $clvsucursal)
    {
        $this->facturacion_model->cancelaRemision($remision);
        redirect('facturacion/listado_remisiones/'.$clvsucursal);
    }

    function remisiones()
    {
        $this->load->library('pagination');
        
        $config['base_url'] = site_url('facturacion/remisiones');
        $config['total_rows'] = $this->facturacion_model->getRemisionesAllCuenta();
        $config['per_page'] = 100;
        $config['uri_segment'] = 3;
        $this->pagination->initialize($config); 

        $data['subtitulo'] = "Ver remisiones generadas";
        $data['js'] = "facturacion/listado_remisiones_js";
        $data['query'] = $this->facturacion_model->getRemisionesAllLimit($config['per_page'], $this->uri->rsegment(3));
        $this->load->view('main', $data);
    }

    function firmadas()
    {
        $data['subtitulo'] = "Ver remisiones firmadas";
        $data['js'] = "facturacion/listado_remisiones_js";
        $data['query'] = $this->facturacion_model->getRemisionesFirmadasAll();
        $this->load->view('main', $data);
    }

    function valida_firma($remision)
    {
        $data['subtitulo'] = "Validar las firmas";
        $data['js'] = "facturacion/listado_remisiones_js";
        $data['query'] = $this->facturacion_model->getRemisionByRemision($remision);
        $this->load->view('main', $data);
    }

    function guarda_validacion()
    {
        $remision = $this->input->post('remision');
        $observaciones = strtoupper($this->input->post('observaciones'));

        $this->facturacion_model->verificaFirma($remision, $observaciones);
        redirect('facturacion/firmadas');
    }

    function facturar($remision)
    {
        $data['subtitulo'] = "Vista previa de la factura";
        $data['remision'] = $remision;
        $data['js'] = "facturacion/facturar_js";
        $data['clientes'] = $this->facturacion_model->getClientesByRemisionCombo($remision);
        $this->load->view('main', $data);
    }

    function getFacturaVistaPrevia()
    {
    	$contratoID = $this->input->post('contratoID');
    	$remision = $this->input->post('remision');
    	$data['remision'] = $remision;
    	$data['query'] = $this->facturacion_model->getFacturaProductosByRemision($remision, 1);
        $data['referencia'] = $this->facturacion_model->getFacturaReferencia($contratoID, $remision, 1);
    	$this->load->view('facturacion/facturaVistaPrevia', $data);
    }

    function facturar_submit()
    {
    	$remision = $this->input->post('remision');
    	$contratoID = $this->input->post('contratoID');

    	$f1 = $this->facturacion_model->getFacturaRemota($contratoID, $remision, 1);
    	$f2 = $this->facturacion_model->getFacturaRemota($contratoID, $remision, 2);


        if($f1 === TRUE && $f2 === TRUE)
        {
            $this->facturacion_model->setFacturada($remision);
        }
    	redirect('facturacion/firmadas');
    }

    function descargaXML($remision_facturaID)
    {
        $query = $this->facturacion_model->getFactura($remision_facturaID);
        $row = $query->row();
        
        $this->load->helper('download');
        $data = file_get_contents($row->xml); // Read the file's contents
        $name = 'factura_'.$row->numfac.'.xml';
        
        force_download($name, $data); 
    }

    function descargaXMLByID($id)
    {
        $query = $this->util->getDataOficina('fDescarga', array('id' => $id));

        $this->load->helper('download');
        $data = file_get_contents($query->xml); // Read the file's contents
        $name = 'factura_'.$query->serie.$query->folio.'.xml';
        
        force_download($name, $data); 
    }

    function descargaPDF($remision_facturaID)
    {
        $query = $this->facturacion_model->getFactura($remision_facturaID);
        $row = $query->row();
        
        $this->load->helper('download');
        $data = file_get_contents($row->pdf); // Read the file's contents
        $name = 'factura_'.$row->numfac.'.pdf';
        
        force_download($name, $data); 
    }

    function descargaPDFByID($id)
    {
        $query = $this->util->getDataOficina('fDescarga', array('id' => $id));

        $this->load->helper('download');
        $data = file_get_contents($query->pdf); // Read the file's contents
        $name = 'factura_'.$query->serie.$query->folio.'.pdf';
        
        force_download($name, $data); 
    }

    function paquetes()
    {
        $data['subtitulo'] = "Paquetes";
        $data['query'] = $this->facturacion_model->getPaquetes();
        $this->load->view('main', $data);
    }

    function recetas()
    {
        $data['subtitulo'] = "Recetas";
        $data['query'] = $this->facturacion_model->getRecetas();
        $this->load->view('main', $data);
    }

    function facturadas()
    {
        $data['subtitulo'] = "Ver remisiones facturadas";
        $data['js'] = "facturacion/listado_remisiones_js";
        $data['query'] = $this->facturacion_model->getRemisionesFacturadasAll();
        $this->load->view('main', $data);
    }

    function reporte_mensual()
    {
        $data['subtitulo'] = "Generar reporte de recetas para SSA";
        $data['js'] = "facturacion/generar_remision_js";
        $this->load->view('main', $data);
    }

    function obtener_reporte_mensual()
    {
        set_time_limit(0);
        ini_set("memory_limit","-1");

        $fecha1 = $this->input->post('fecha1');
        $fecha2 = $this->input->post('fecha2');
        
        // output headers so that the file is downloaded rather than displayed
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename=dataReceta_'.$fecha1.'_'.$fecha2.'_'.date('YmdHis').'.csv');
        
        // create a file pointer connected to the output stream
        $output = fopen('php://output', 'w');
        
        // output the column headings
        //descsucursal, domicilio, paciente, cvepaciente, fecha, folioreceta, programa, nombremedico, cvemedico, desservicios, cvearticulo, clave, susa, descripcion, pres, canreq, cansur, precio
        fputcsv($output, array('JURISDICCION', 'SUCURSAL','DOMICILIO','PACIENTE','AFILIACION','FECHA','FOLIO DE RECETA','COBERTURA','NOMBRE DE MEDICO','CLAVE DE MEDICO','SERVICIO','CLAVE FENIX','CLAVE SSA','SUSTANCIA ACTIVA','DESCRIPCION', 'PRESENTACION', 'CANTIDAD REQUERIDA', 'CANTIDAD SURTIDA', 'PRECIO'));
        
            
            $sql = "SELECT descsucursal, concat(calle, ' ', colonia, ' ', municipio, ' ', cp) as domicilio, concat(nombre, ' ', apaterno, ' ', amaterno) as paciente, cvepaciente, fecha, folioreceta, programa, nombremedico, cvemedico, desservicios, cvearticulo, clave, susa, descripcion, pres, canreq, cansur, precio, jurisdiccion
FROM receta r
join receta_detalle d using(consecutivo)
join articulos a using(id)
join sucursales s using(clvsucursal)
join jurisdiccion j using(numjurisd)
join programa p using(idprograma)
join fservicios f on r.cveservicio = f.cveservicios
where fecha between ? and ?
order by numjurisd, clvsucursal, fecha, folioreceta, tipoprod, cvearticulo * 1;";
            $query = $this->db->query($sql, array((string)$fecha1, (string)$fecha2));

        
        // fetch the data
        
        foreach($query->result() as $row)
        {
        	//descsucursal, domicilio, paciente, cvepaciente, fecha, folioreceta, programa, nombremedico, cvemedico, desservicios, cvearticulo, clave, susa, descripcion, pres, canreq, cansur, precio
            fputcsv($output, array($row->jurisdiccion, $row->descsucursal, $row->domicilio, $row->paciente, $row->cvepaciente, $row->fecha, $row->folioreceta, $row->programa, $row->nombremedico, $row->cvemedico, $row->desservicios, $row->cvearticulo, $row->clave, $row->susa, $row->descripcion, $row->pres, $row->canreq, $row->cansur, $row->precio)); 
        }

    }

    function reporte_mensual_extendido()
    {
        $data['subtitulo'] = "Generar reporte de recetas para SSA";
        $data['js'] = "facturacion/generar_remision_js";
        $this->load->view('main', $data);
    }

    function obtener_reporte_mensual_extendido()
    {
        set_time_limit(0);
        ini_set("memory_limit","-1");

        $fecha1 = $this->input->post('fecha1');
        $fecha2 = $this->input->post('fecha2');
        $req = $this->input->post('req');

        if($req == 1 || $req == 2 || $req == 3)
        {
        	$filtro = ' and tiporequerimiento = ' . $req;
        }elseif($req == 4)
        {
        	$filtro = ' and tiporequerimiento in(1, 2)';
        }elseif($req == 5)
        {
        	$filtro = null;
        }
        
        // output headers so that the file is downloaded rather than displayed
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename=dataReceta_'.$fecha1.'_'.$fecha2.'_'.date('YmdHis').'.csv');
        
        // create a file pointer connected to the output stream
        $output = fopen('php://output', 'w');
        
        // output the column headings
        //descsucursal, domicilio, paciente, cvepaciente, fecha, folioreceta, programa, nombremedico, cvemedico, desservicios, cvearticulo, clave, susa, descripcion, pres, canreq, cansur, precio
        fputcsv($output, array('JURISDICCION', 'SUCURSAL','DOMICILIO','PACIENTE','AFILIACION','FECHA','FOLIO DE RECETA','COBERTURA','NOMBRE DE MEDICO','CLAVE DE MEDICO','SERVICIO','SUMINISTRO','REQUERIMIENTO','CLAVE FENIX','CLAVE SSA','SUSTANCIA ACTIVA','DESCRIPCION', 'PRESENTACION', 'CANTIDAD REQUERIDA', 'CANTIDAD SURTIDA', 'PRECIO', 'IMPORTE', 'IVA PRODUCTO', 'SERVICIO', 'IVA SERVICIO', 'SUBTOTAL'));
        
            
            $sql = "SELECT descsucursal, concat(calle, ' ', colonia, ' ', municipio, ' ', cp) as domicilio, concat(nombre, ' ', apaterno, ' ', amaterno) as paciente, cvepaciente, fecha, folioreceta, programa, nombremedico, cvemedico, desservicios, cvearticulo, clave, susa, descripcion, pres, canreq, cansur, precio, jurisdiccion, suministro, requerimiento, cansur * precio as importe, case when iva = 1 then cansur * precio * 0.16 else 0 end as iva_producto, cansur * d.servicio as servicio, cansur * d.servicio * 0.16 as iva_servicio, case when iva = 1 then (cansur * precio * 1.16) + (cansur * d.servicio * 1.16) else (cansur * precio) + (cansur * d.servicio * 1.16) end as subtotal
FROM receta r
join receta_detalle d using(consecutivo)
join articulos a using(id)
join sucursales s using(clvsucursal)
join jurisdiccion j using(numjurisd)
left join programa p using(idprograma)
left join fservicios f on r.cveservicio = f.cveservicios
left join temporal_suministro u on a.tipoprod = u.cvesuministro
left join temporal_requerimiento q using(tiporequerimiento)
where fecha between ? and ? $filtro
order by numjurisd, clvsucursal, fecha, folioreceta, tipoprod, cvearticulo * 1;";
            $query = $this->db->query($sql, array((string)$fecha1, (string)$fecha2));

        
        // fetch the data
        
        foreach($query->result() as $row)
        {
        	//descsucursal, domicilio, paciente, cvepaciente, fecha, folioreceta, programa, nombremedico, cvemedico, desservicios, cvearticulo, clave, susa, descripcion, pres, canreq, cansur, precio
            fputcsv($output, array($row->jurisdiccion, $row->descsucursal, $row->domicilio, $row->paciente, $row->cvepaciente, $row->fecha, $row->folioreceta, $row->programa, $row->nombremedico, $row->cvemedico, $row->desservicios, $row->suministro, $row->requerimiento, $row->cvearticulo, $row->clave, $row->susa, $row->descripcion, $row->pres, $row->canreq, $row->cansur, $row->precio, $row->importe, $row->iva_producto, $row->servicio, $row->iva_servicio, $row->subtotal)); 
        }

    }

    function reporte_facturas()
    {
        $data['subtitulo'] = "Reporte de facturas";
        $data['query'] = $this->facturacion_model->getReporteFacturas();
        $this->load->view('main', $data);
    }

    function getFacturasExcel()
    {
        $this->facturacion_model->getReporteFacturasExcel();
        $filename = 'Reporte_de_facturas_'.date('Ymd_his').'.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache
        $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
        $objWriter->save('php://output');
    }

    function dashboard()
    {
        $data['subtitulo'] = "Dashboard";;
        $data['query'] = $this->facturacion_model->getTotalesByRequerimiento();
        $data['mensual'] = $this->facturacion_model->mensual();
        $data['semanal'] = $this->facturacion_model->semanal();
        $data['total'] = $this->facturacion_model->getConcentradoVenta();
        $data['articulos'] = $this->facturacion_model->getConcentradoVentaArticulo();
        $data['totalFarmacias'] = $this->facturacion_model->getConcentradoVentaFarmacias(1);
        $data['farmacias'] = $this->facturacion_model->getConcentradoVentaSucursal(1);
        $data['totalJuris'] = $this->facturacion_model->getConcentradoVentaFarmacias(2);
        $data['juris'] = $this->facturacion_model->getConcentradoVentaSucursal(2);
        $data['totalPaquetes'] = $this->facturacion_model->getConcentradoVentaFarmacias(3);
        $data['paqueteslist'] = $this->facturacion_model->getConcentradoVentaSucursal(3);
        $data['js'] = 'facturacion/dashboard_js';
        $this->load->view('main', $data);

    }

    function canceladas()
    {
        $data['subtitulo'] = "Ver remisiones canceladas";
        $data['js'] = "facturacion/listado_remisiones_js";
        $data['query'] = $this->facturacion_model->getRemisionesCanceladas();
        $this->load->view('main', $data);
    }

    function reactivar_remision($remision)
    {
        $data['subtitulo'] = "Reactivar Remisión";
        $data['remision'] = $remision;
        $this->load->view('main', $data);
    }

    function dias_de_captura()
    {
        $data['subtitulo'] = "Reporte";
        $data['anio'] = $this->util->getAnioCombo();
        $data['mes'] = $this->util->getMesCombo();
        $this->load->view('main', $data);
    }

    function dias_de_captura_resultado()
    {
        $anio = $this->input->post('anio');
        $mes = $this->input->post('mes');

        $data['subtitulo'] = "Reporte";
        $data['query'] = $this->facturacion_model->getDiasCaptura($anio, $mes);
        $data['anio'] = $anio;
        $data['mes'] = $mes;
        $this->load->view('main', $data);
    }

    function eliminar_recetas()
    {
        $data['subtitulo'] = "Eliminar recetas";
        $data['js'] = "facturacion/generar_remision_js";
        $data['sucursales'] = $this->util->getSucursalesCombo();
        $this->load->view('main', $data);
    }

    function eliminar_recetas_previo()
    {
        $fecha1 = $this->input->post('fecha1');
        $fecha2 = $this->input->post('fecha2');
        $clvsucursal = $this->input->post('clvsucursal');
        $data['fecha1'] = $fecha1;
        $data['fecha2'] = $fecha2;
        $data['clvsucursal'] = $clvsucursal;
        $data['query'] = $this->facturacion_model->getRecetasEliminar($fecha1, $fecha2, $clvsucursal);
        $data['subtitulo'] = 'Resultado de la busqueda';
        $this->load->view('main', $data);
    }

    function eliminar_recetas_listado($fecha1, $fecha2, $clvsucursal)
    {
    	$this->facturacion_model->deleteRecetasEliminar($fecha1, $fecha2, $clvsucursal);
    	redirect('facturacion/eliminar_recetas');
    }

    function mensual()
    {
        $data['subtitulo'] = "Reporte Mensual";
        $data['anio'] = $this->util->getAnioCombo();
        $data['mes'] = $this->util->getMesCombo();
        $this->load->view('main', $data);
    }

    function mensual2()
    {
        $data['subtitulo'] = "Reporte Mensual";
        $data['anio'] = $this->util->getAnioCombo();
        $data['mes'] = $this->util->getMesCombo();
        $this->load->view('main', $data);
    }

    function getMensualExcel()
    {
    	$anio = $this->input->post('anio');
    	$mes = $this->input->post('mes');
        $this->facturacion_model->getReporteMensualExcel($anio, $mes);
        $filename = 'Reporte_mensual_' . $anio . '_' . $mes . '_' . date('Ymd_his').'.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache
        $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
        $objWriter->save('php://output');
    }

    function get_reporte_mensual()
    {
        set_time_limit(0);
        ini_set("memory_limit","-1");

    	$anio = $this->input->post('anio');
    	$mes = $this->input->post('mes');
        
        // output headers so that the file is downloaded rather than displayed
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename=dataReceta_'.$anio.'_'.$mes.'_'.date('YmdHis').'.csv');
        
        // create a file pointer connected to the output stream
        $output = fopen('php://output', 'w');
        
        // output the column headings
        //descsucursal, domicilio, paciente, cvepaciente, fecha, folioreceta, programa, nombremedico, cvemedico, desservicios, cvearticulo, clave, susa, descripcion, pres, canreq, cansur, precio
        fputcsv($output, array('JURISDICCION','SUCURSAL','FOLIO RECETA','COBERTURA','NOMBRE MEDICO','SUMINISTRO','REQUERIMIENTO','CLAVE CORTA','CLAVE SSA','SUSTANCIA ACTIVA','REQUERIDA','SURTIDA','PRECIO UNITARIO','IMPORTE','IVA PRODUCTO','SERVICIO','IVA SERVICIO','SUBTOTAL'));
        
            
            $query = $this->facturacion_model->getDesgloseConsumo($anio, $mes);

        
        // fetch the data
        
        foreach($query->result() as $row)
        {
        	//descsucursal, domicilio, paciente, cvepaciente, fecha, folioreceta, programa, nombremedico, cvemedico, desservicios, cvearticulo, clave, susa, descripcion, pres, canreq, cansur, precio
            fputcsv($output, array($row->jurisdiccion, $row->descsucursal, $row->folioreceta, $row->programa, $row->nombremedico, $row->suministro, $row->requerimiento, $row->cvearticulo, $row->clave, $row->susa, $row->canreq, $row->cansur, $row->precio, $row->importe, $row->iva_producto, $row->servicio, $row->iva_servicio, $row->subtotal)); 
        }

    }

    function sincronizar()
    {
    	$this->facturacion_model->sincronizarServidores();
    	redirect('facturacion/reporte_facturas');
    }

    function controlado()
    {
        $data['subtitulo'] = "Facturas de controlados";
        $data['query'] = $this->util->getDataOficina('fControlado', array('receptores' => $this->facturacion_model->getReceptores()));
        //$data['js'] = "inventario/por_sucursal_js";
        $this->load->view('main', $data);
    }

    function controlado_addenda($f_id)
    {
        $data['subtitulo'] = "Addenda de controlados";
        $data['query'] = $this->util->getDataOficina('fDescarga', array('id' => $f_id));
        //$data['js'] = "inventario/por_sucursal_js";
        $this->load->view('main', $data);
    }
}