<?php if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Medico extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();

        if (!Current_User::user()) {
            redirect('welcome');
        }
        
        $this->load->model('medico_model');
        $this->load->model('captura_model');
        $this->load->helper('utilities');
        date_default_timezone_set('America/Mexico_City');

    }

    function config()
    {
        $data['subtitulo'] = "Configuracion";
        $data['js'] = "medico/config_js";
        $data['categoria'] = $this->captura_model->getCveServicioCombo();
        $data['query'] = $this->medico_model->getConfig();
        $this->load->view('main', $data);
    }

    function nueva__configuracion()
    {
        $cvemedico = $this->input->post('cvemedico');
        $nombremedico = $this->input->post('nombremedico');
        $cveservicios = $this->input->post('cveservicios');

        $this->medico_model->addConfig($cvemedico, $nombremedico, $cveservicios);
        redirect('medico/config');
    }

    function nueva()
    {
    	$query = $this->medico_model->getConfig();
    	if($query->num_rows() == 0)
    	{
    		redirect('medico/config');
    	}
        $data['subtitulo'] = "Nueva Receta";
        $data['js'] = "medico/nueva_js";
        $data['sexo'] = $this->captura_model->getSexoCombo();
        $data['programa'] = $this->captura_model->getProgramaCombo();
        $this->load->view('main', $data);
    }

    function nueva__receta()
    {
        $recetaID = $this->medico_model->save();
        redirect('medico/recetas/' . $this->input->post('expediente'));
    }

    function recetas($cvepaciente = null)
    {
        $query = $this->medico_model->getConfig();
        if($query->num_rows() == 0)
        {
            redirect('medico/config');
        }
        $data['subtitulo'] = "Recetas expedidas";
        $data['js'] = "medico/recetas_js";
        $data['titular'] = $this->medico_model->getTitular($cvepaciente);
        $data['query'] = $this->medico_model->getRecetas($cvepaciente);
        $data['sexo'] = $this->captura_model->getSexoCombo();
        $data['programa'] = $this->captura_model->getProgramaCombo();
        $data['cronicas'] = $this->medico_model->getCronicasPresentes($cvepaciente);
        $this->load->view('main', $data);
    }

    function imprimeReceta($recetaID)
    {
        set_time_limit(0);
        ini_set('memory_limit','-1');

        $data['header'] = $this->medico_model->headerRecetaElectronica($recetaID);
        $data['detalle'] = $this->medico_model->detalleRecetaElectronica($recetaID);
        $data['fin'] = $this->medico_model->finRecetaElectronica($recetaID);
        $data['recetaID'] = $recetaID;

        $this->load->view('impresiones/recetaElectronica', $data);

    }

    function cancelaReceta($recetaID)
    {
    	$this->medico_model->cancela($recetaID);
    	redirect('medico/recetas');
    }

    function verificaCveArticulo()
    {
        $cveArticulo = $this->input->post('cveArticulo');
        $idprograma = $this->input->post('idprograma');

        echo $this->medico_model->validaArticulo($cveArticulo, $idprograma);
    }

    function titulares()
    {
        $data['subtitulo'] = "Titulaes";
        $data['js'] = "medico/titulares_js";
        $data['query'] = $this->medico_model->getTitulares();
        $this->load->view('main', $data);
    }

    function nuevo_titular()
    {
        $data['subtitulo'] = "Nuevo titular";
        $data['js'] = "medico/nueva_js";
        $data['sexo'] = $this->captura_model->getSexoCombo();
        $data['programa'] = $this->captura_model->getProgramaCombo();
        $this->load->view('main', $data);
    }

    function insert_nuevo_titular()
    {
        $result = $this->medico_model->insertTitular();
        redirect('medico/titulares');
    }

    function editar_paciente($cvepaciente)
    {
        $data['subtitulo'] = "Editar datos del paciente";
        //$data['js'] = "medico/nueva_js";
        $data['paciente'] = $this->medico_model->getPaciente($cvepaciente);
        $data['sexo'] = $this->captura_model->getSexoCombo();
        $data['programa'] = $this->captura_model->getProgramaCombo();
        $data['dependencias'] = $this->captura_model->getDependencias();
        $this->load->view('main', $data);
    }

    function update_paciente()
    {
        $result = $this->medico_model->updatePaciente();
        redirect('medico/titulares');
    }

    function dependientes($cvepaciente)
    {
        $data['subtitulo'] = "Nuevo titular";
        $data['js'] = "medico/nueva_js";
        $data['titular'] = $this->medico_model->getTitular($cvepaciente);
        $data['query'] = $this->medico_model->getDependientes($cvepaciente);
        $data['sexo'] = $this->captura_model->getSexoCombo();
        $data['programa'] = $this->captura_model->getProgramaCombo();
        $data['dependencias'] = $this->captura_model->getDependencias();
        $this->load->view('main', $data);
    }

    function insert_nuevo_dependiente()
    {
        $result = $this->medico_model->insertDependiente();
        redirect('medico/dependientes/' . $this->input->post('cvepaciente'));
    }

    function expediente($cvepaciente = null)
    {
        $data['subtitulo'] = "Expediente electrónico";
        $data['js'] = "medico/expediente_js";
        $data['titular'] = $this->medico_model->getTitular($cvepaciente);
        $data['query'] = $this->medico_model->getExpediente($cvepaciente);
        $data['cvepaciente'] = $cvepaciente;        ;
        //$data['sexo'] = $this->captura_model->getSexoCombo();
        //$data['programa'] = $this->captura_model->getProgramaCombo();
        $data['cronicas'] = $this->medico_model->getCronicasPaciente($cvepaciente);
        $data['recetas'] = $this->medico_model->recetasExpedidas($cvepaciente);
        $this->load->view('main', $data);
    }

    function insert_expediente()
    {
        $result = $this->medico_model->insertExpediente();
        redirect('medico/expediente/' . $this->input->post('cvepaciente'));
    }

    function insert_cronica()
    {
        $this->medico_model->insertCronica();
    }

    function expedienteExcel($cvepaciente)
    {
        $this->medico_model->getExpedienteExcel($cvepaciente);
        $filename = $this->uri->segment(2).'_'.date('Ymd_his').'.xls'; //save our workbook as this file name
        header('Content-Type: application/vnd.ms-excel'); //mime type
        header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
        header('Cache-Control: max-age=0'); //no cache
        $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');  
        $objWriter->save('php://output');   
    }
}