<?php
global $cabezota;
global $piezote;

$cabezota = $cabeza;
$piezote = $pie;

require_once('tcpdf/config/tcpdf_config.php');
require_once('tcpdf/tcpdf.php');



// Extend the TCPDF class to create custom Header and Footer 
class MYPDF extends TCPDF { 
    
    
    public function Header() { 

        /////////////////////////////////////////////////////////////////
        global $cabezota;

        $this->SetFont('helvetica', '', 6   );
$tbl = <<<EOD
$cabezota
EOD;
        $this->writeHTML($tbl, true, false, false, false, '');
    } 
     
    // Page footer 
    public function Footer() {

        global $piezote;
        // Position at 1.5 cm from bottom 
        $this->SetY(-10); 
        // Set font 
        $this->SetFont('helvetica', 'I', 8); 
        // Page number 
        //$this->Cell(0, 10, 'Pagina '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, 0, 'C');
$tbl = <<<EOD
$piezote
EOD;
        $this->writeHTML($tbl, true, false, false, false, '');
        $this->Cell(0, 10, 'Pagina '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, 0, 'C');
    } 
} 

// create new PDF document 
$pdf = new MYPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false); 

// set document information 
$pdf->SetCreator(PDF_CREATOR); 
$pdf->SetAuthor('Ivan Zuñiga Perez'); 
$pdf->SetTitle('REMISION'); 
$pdf->SetSubject(''); 
$pdf->SetKeywords(''); 

// set default header data 
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING); 

// set header and footer fonts 
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN)); 
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA)); 

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

//set margins 
$pdf->SetMargins(7, 35, 6); 
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER); 
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER); 

//set auto page breaks 
$pdf->SetAutoPageBreak(TRUE, 10); 

//set image scale factor 
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);  

$pdf->SetFont('helvetica', '', 5    );

$t_cantidad = 0;
$t_subtotal = 0;
$t_iva = 0;
$t_total = 0;


foreach ($fechas->result() as $f) {


$pdf->AddPage();

$cantidad = 0;
$subtotal = 0;
$iva = 0;
$total = 0;

$query = $this->reportes_model->getPeriodoFacturado($f->fecha_sistema, $f->fecha_sistema, $f->unidad);

foreach($query->result() as $row)
{
    

$tabla = "<table cellpadding=\"1\">
    <tbody>
        <tr>
            <td style=\"width: 4%;\">".$row->fecha_sistema."</td>
            <td style=\"width: 5%;\">".$row->receta."</td>
            <td style=\"width: 4%;\">".$row->fecha_receta."</td>
            <td style=\"width: 7%;\">".'Seguro Popular'. "</td>
            <td style=\"width: 6%; \">".$row->dispensacion."</td>
            <td style=\"width: 12%;\">".$row->nombre."</td>
            <td style=\"width: 6%; \">".$row->clave."</td>
            <td style=\"width: 13%;\">".$row->descripcion."</td>
            <td style=\"width: 7%;\">".$row->presentacion."</td>
            <td style=\"width: 6%;\">".$row->ean."</td>
            <td style=\"width: 5%;\">".$row->lote."</td>
            <td style=\"width: 5%; text-align: right; \">".number_format($row->cantidad, 0)."</td>
            <td style=\"width: 5%; text-align: right; \">".number_format($row->precio, 2)."</td>
            <td style=\"width: 5%; text-align: right; \">".number_format($row->subtotal, 2)."</td>
            <td style=\"width: 5%; text-align: right; \">".number_format($row->iva, 2)."</td>
            <td style=\"width: 5%; text-align: right; \">".number_format($row->total, 2)."</td>
        </tr>
    </tbody>
    </table>";
    
    $cantidad = $cantidad + $row->cantidad;
    $subtotal = $subtotal + $row->subtotal;
    $iva = $iva + $row->iva;
    $total = $total + $row->total;

    $t_cantidad = $t_cantidad + $row->cantidad;
    $t_subtotal = $t_subtotal + $row->subtotal;
    $t_iva = $t_iva + $row->iva;
    $t_total = $t_total + $row->total;
//echo $tabla;

$tbl= <<<EOD
$tabla
EOD;

$pdf->writeHTML($tbl, true, false, false, false, '');

}       

$tabla ="
<table>
</tfoot>
        <tr>
            <td colspan=\"8\" style=\"text-align: right; width: 75%; \">TOTAL DIA ".$f->fecha_sistema.": </td>
            <td style=\"text-align: right; width: 5%; \"><b>".number_format($cantidad, 0)."</b></td>
            <td style=\"text-align: right; width: 5%; \"></td>
            <td style=\"text-align: right; width: 5%; \"><b>".number_format($subtotal, 2)."</b></td>
            <td style=\"text-align: right; width: 5%; \"><b>".number_format($iva, 2)."</b></td>
            <td style=\"text-align: right; width: 5%; \"><b>".number_format($total, 2)."</b></td>
        </tr>
        </tfoot>
        </table>";

// set font

//echo $tabla;        
$tbl= <<<EOD
$tabla
EOD;

$pdf->writeHTML($tbl, true, false, false, false, '');


    # code...
}


$tabla ="
<table>
</tfoot>
        <tr>
            <td colspan=\"8\" style=\"text-align: right; width: 75%; \">TOTAL: </td>
            <td style=\"text-align: right; width: 5%; \"><b>".number_format($t_cantidad, 0)."</b></td>
            <td style=\"text-align: right; width: 5%; \"></td>
            <td style=\"text-align: right; width: 5%; \"><b>".number_format($t_subtotal, 2)."</b></td>
            <td style=\"text-align: right; width: 5%; \"><b>".number_format($t_iva, 2)."</b></td>
            <td style=\"text-align: right; width: 5%; \"><b>".number_format($t_total, 2)."</b></td>
        </tr>
        </tfoot>
        </table>";

// set font

//echo $tabla;        
$tbl= <<<EOD
$tabla
EOD;

$pdf->writeHTML($tbl, true, false, false, false, '');

// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------



//Close and output PDF document
$pdf->Output($file, 'D');

//============================================================+
// END OF FILE                                                 
//============================================================+