<?php
class Almacen_model extends CI_Model {

    /**
     * Catalogos_model::__construct()
     * 
     * @return
     */
    function __construct()
    {
        parent::__construct();
    }
    
    function getAreas()
    {
        $this->db->where('clvsucursal', $this->session->userdata('clvsucursal'));
        $query = $this->db->get('area');
        return $query;
    }
    
    function getArea($areaID)
    {
        $this->db->where('areaID', $areaID);
        $query = $this->db->get('area');
        return $query;
    }
    
    function insertArea($area)
    {
        $this->db->where('area', $area);
        $this->db->where('clvsucursal', $this->session->userdata('clvsucursal'));
        $query = $this->db->get('area');
        
        if($query->num_rows() == 0)
        {
            $data = array('area' => $area, 'clvsucursal' => $this->session->userdata('clvsucursal'));
            $this->db->insert('area', $data);
        }
    }
    
    function updateArea($areaID, $area, $agrupacion)
    {
        $this->db->update('area', array('area' => $area, 'agrupacion' => $agrupacion), array('areaID' => $areaID));
    }
    
    function getRackByRackID($rackID)
    {
        $this->db->where('rackID', $rackID);
        $query = $this->db->get('rack');
        return $query;
    }
    
    function getPasillosByAreaID($areaID)
    {
        $sql = "SELECT *, count(*) as posiciones FROM pasillo p
left join area a using(areaID)
left join rack r using(rackID)
left join pasillo_tipo o using(pasilloTipo)
left join pasillo_sentido s using(sentido)
left join modulo m using(pasilloID)
left join nivel n using(pasilloID, moduloID)
left join posicion c using(pasilloID, moduloID, nivelID)
where areaID = ?
group by pasilloID;";

        $query = $this->db->query($sql, $areaID);
        return $query;
    }
    
    function insertPasillo($data)
    {
        $this->db->insert('pasillo', $data);
    }

    function updatePasillo($data, $pasilloID)
    {
        $this->db->update('pasillo', $data, array('pasilloID' => $pasilloID));
    }

    function getPasilloByPasilloID($pasilloID)
    {
        $sql = "SELECT * FROM pasillo p
join area a using(areaID)
join rack r using(rackID)
join pasillo_tipo o using(pasilloTipo)
join pasillo_sentido s using(sentido)
where pasilloID = ?;";

        $query = $this->db->query($sql, $pasilloID);
        return $query;
    }
    
    function getModulosByPasilloID($pasilloID)
    {
        $sql = "SELECT moduloID, count(*) as posiciones FROM modulo m
join pasillo p using(pasilloID)
join nivel n using(pasilloID, moduloID)
join posicion s using(pasilloID, moduloID, nivelID)
join pasillo_sentido i using(sentido)
where pasilloID = ?
group by moduloID;";

        $query = $this->db->query($sql, $pasilloID);
        
        return $query;
    }
    
    function getOrdenamientoPasillo($pasilloID)
    {
        $sql = "SELECT ordenamiento FROM pasillo p
join pasillo_sentido s using(sentido)
where pasilloID = ?;";
        $query = $this->db->query($sql, $pasilloID);
        
        if($query->num_rows() > 0)
        {
            $row = $query->row();
            return $row->ordenamiento;
        }else{
            return null;
        }
    }
    
    function drawModuloQuery($pasilloID)
    {
        $ordenamiento = $this->getOrdenamientoPasillo($pasilloID);
        $sql = "SELECT moduloID FROM modulo m where pasilloID = ? order by moduloID $ordenamiento;";
        
        $query = $this->db->query($sql, $pasilloID);
        
        return $query;
        
    }
    
    function lastModulo($pasilloID)
    {
        $sql = "SELECT max(moduloID) as moduloID FROM modulo m where pasilloID = ?;";
        $query = $this->db->query($sql, $pasilloID);
        $row = $query->row();
        return $row->moduloID;
    }
    
    function drawModulo($pasilloID)
    {
        $modulo = '<table class="table table-striped table-bordered" style="font-size: smaller; vertical-align: bottom;">
    <tr>';
    
        $query = $this->drawModuloQuery($pasilloID);
        $lastModulo = $this->lastModulo($pasilloID);
        
        foreach($query->result() as $row)
        {
            if($lastModulo == $row->moduloID)
            {
                $borraModulo = anchor('almacen/eliminaModulo/'.$pasilloID.'/'.$row->moduloID, 'Eliminar', array('class' => 'elimina', 'rel' => 'MODULO'));
            }else{
                $borraModulo = null;
            }
            $modulo .= '<td style="vertical-align: bottom;">'.$this->drawNivel($pasilloID, $row->moduloID).'Modulo '.$row->moduloID.' '.$borraModulo.'</td>';
        }
        
        $modulo .= '    
        </tr>
    </table>';

        return $modulo;
    }
    
    function drawModuloInventario($pasilloID)
    {
        $modulo = '<table class="table table-striped table-bordered" style="font-size: smaller; vertical-align: bottom;">
    <tr>';
    
        $query = $this->drawModuloQuery($pasilloID);
        
        foreach($query->result() as $row)
        {
            $modulo .= '<td style="vertical-align: bottom;">'.$this->drawNivelInventario($pasilloID, $row->moduloID).'Modulo '.$row->moduloID.'</td>';
        }
        
        $modulo .= '    
        </tr>
    </table>';

        return $modulo;
    }

    function drawNivelQuery($pasilloID, $moduloID)
    {
        $sql = "SELECT nivelID FROM nivel n where pasilloID = ? and moduloID = ? order by nivelID desc;";
        $query = $this->db->query($sql, array($pasilloID, $moduloID));
        return $query;
    }
    
    function lastNivel($pasilloID, $moduloID)
    {
        $sql = "SELECT max(nivelID) as nivelID FROM nivel n where pasilloID = ? and moduloID = ?;";
        $query = $this->db->query($sql, array($pasilloID, $moduloID));
        $row = $query->row();
        return $row->nivelID;
    }

    function drawNivel($pasilloID, $moduloID)
    {
        $nivel = '
        <table class="table table-striped table-bordered">';
        
        $query = $this->drawNivelQuery($pasilloID, $moduloID);
        $lastNivel = $this->lastNivel($pasilloID, $moduloID);
        

        foreach($query->result() as $row)
        {
            if($lastNivel == $row->nivelID)
            {
                $borraNivel = anchor('almacen/eliminaNivel/'.$pasilloID.'/'.$moduloID.'/'.$row->nivelID, 'Eliminar', array('class' => 'elimina', 'rel' => 'NIVEL')).' | '.anchor('almacen/agregaNivel/'.$pasilloID.'/'.$moduloID.'/'.$row->nivelID, 'Agregar', array('class' => 'agrega', 'rel' => 'NIVEL'));
            }else{
                $borraNivel = null;
            }

            $nivel .= '
            <tr>
                <td>'.$this->drawPosicion($pasilloID, $moduloID, $row->nivelID).'Nivel '.$row->nivelID.' '.$borraNivel.'</td>
            </tr>';
        }
        
        $nivel .='        
        </table>';
        
        return $nivel;
    }

    function drawNivelInventario($pasilloID, $moduloID)
    {
        $nivel = '
        <table class="table table-striped table-bordered">';
        
        $query = $this->drawNivelQuery($pasilloID, $moduloID);

        foreach($query->result() as $row)
        {

            $nivel .= '
            <tr>
                <td>'.$this->drawPosicionInventario($pasilloID, $moduloID, $row->nivelID).'Nivel '.$row->nivelID.'</td>
            </tr>';
        }
        
        $nivel .='        
        </table>';
        
        return $nivel;
    }

    function drawPosicionQuery($pasilloID, $moduloID, $nivelID)
    {
        $sql = "SELECT p.*, ifnull(cvearticulo, 'VACIO') as cvearticulo, ifnull(minimo, 0) as minimo, ifnull(maximo, 0) as maximo
FROM posicion p
join pasillo o using(pasilloID)
left join articulos a using(id)
where pasilloID = ? and moduloID = ? and nivelID = ?
order by posicionID";
        $query = $this->db->query($sql, array($pasilloID, $moduloID, $nivelID));
        return $query;
    }
    
    function lastPosicion($pasilloID, $moduloID, $nivelID)
    {
        $sql = "SELECT max(posicionID) as posicionID FROM posicion p where pasilloID = ? and moduloID = ? and nivelID = ?;";
        $query = $this->db->query($sql, array($pasilloID, $moduloID, $nivelID));
        $row = $query->row();
        return $row->posicionID;
    }

    function drawPosicion($pasilloID, $moduloID, $nivelID)
    {
        $posicion = '<table class="table table-striped table-bordered">
            <tr>';
        
        $query = $this->drawPosicionQuery($pasilloID, $moduloID, $nivelID);
        $lastPosicion = $this->lastPosicion($pasilloID, $moduloID, $nivelID);
        
        foreach($query->result() as $row)
        {
            if($lastPosicion == $row->posicionID)
            {
                $borraPosicion = anchor('almacen/eliminaPosicion/'.$row->ubicacion, ' <i class="icon-minus"></i> ', array('class' => 'elimina', 'rel' => 'POSICION')).anchor('almacen/agregaPosicion/'.$row->ubicacion, ' <i class="icon-plus"></i> ', array('class' => 'agrega', 'rel' => 'POSICION'));
            }else{
                $borraPosicion = null;
            }
            
            if($row->id == 0)
            {
                $link = '<a href="#" id="id-btn-dialog-'.$row->ubicacion.'" class="btn btn-purple btn-small" rel="'.$row->id.'" minimo="'.$row->minimo.'" maximo="'.$row->maximo.'">Asignar Clave</a>';
            }else{
                $link = '<a href="#" id="id-btn-dialog-'.$row->ubicacion.'" class="btn btn-info btn-small" rel="'.$row->id.'" minimo="'.$row->minimo.'" maximo="'.$row->maximo.'">'.$row->cvearticulo.'</a>';
            }
            
            

            $posicion .= '
            <td>Pos. '.$row->posicionID.' '.$borraPosicion.'<br />'.$link.'</td>
            ';
        }
        
        $posicion .= '
            </tr>
        </table>
        ';
        
        return $posicion;
    }
    
    function drawPosicionInventario($pasilloID, $moduloID, $nivelID)
    {
        $posicion = '<table class="table table-striped table-bordered">
            <tr>';
        
        $query = $this->drawPosicionQuery($pasilloID, $moduloID, $nivelID);
        
        foreach($query->result() as $row)
        {
            
            if($row->cvearticulo == 'VACIO')
            {
                $pos = '<span style="color: green;"> -> LIBRE</span>';
            }else{
                $pos = '<span style="color: red;"> -> '.$row->cvearticulo.'</span>';
            }
            
            $posicion .= '
            <td id="ubicacion_'.$row->ubicacion.'" clave="'.$row->cvearticulo.'">Pos. '.$row->posicionID.' '.$pos.'</td>
            ';
        }
        
        $posicion .= '
            </tr>
        </table>
        ';
        
        return $posicion;
    }

    function eliminaUbicacion($ubicacion)
    {
        $this->db->delete('posicion', array('ubicacion' => $ubicacion));
    }
    
    function getPosicionByUbicacion($ubicacion)
    {
        $this->db->where('ubicacion', $ubicacion);
        $query = $this->db->get('posicion');
        return $query;
    }
    
    function agregaUbicacion($ubicacion)
    {
        $query = $this->getPosicionByUbicacion($ubicacion);
        $row = $query->row();
        $data = array('posicionID' => ($row->posicionID + 1), 'nivelID' => $row->nivelID, 'moduloID' => $row->moduloID, 'pasilloID' => $row->pasilloID, 'id' => 0);
        $this->db->insert('posicion', $data);
    }
    
    function eliminaNivel($pasilloID, $moduloID, $nivelID)
    {
        $this->db->trans_start();
        $sql_delete_posicion = "DELETE FROM posicion where pasilloID = ? and moduloID = ? and nivelID = ?;";
        $this->db->query($sql_delete_posicion, array($pasilloID, $moduloID, $nivelID));
        
        $sql_delete_nivel = "DELETE FROM nivel where pasilloID = ? and moduloID = ? and nivelID = ?;";
        $this->db->query($sql_delete_nivel, array($pasilloID, $moduloID, $nivelID));
        $this->db->trans_complete();
    }
    
    function agregaNivel($pasilloID, $moduloID, $nivelID, $posiciones)
    {
        $this->db->trans_start();
        $data = array('nivelID' => ($nivelID + 1), 'moduloID' => $moduloID, 'pasilloID' => $pasilloID);
        $this->db->insert('nivel', $data);
        
        for($i = 1; $i <= $posiciones; $i++)
        {
            $data2 = array('posicionID' => $i, 'nivelID' => ($nivelID + 1), 'moduloID' => $moduloID, 'pasilloID' => $pasilloID, 'id' => 0);
            $this->db->insert('posicion', $data2);
        }
        
        $this->db->trans_complete();
    }
    
    function eliminaModulo($pasilloID, $moduloID)
    {
        $this->db->trans_start();
        
        $sql_posicion = "DELETE FROM posicion where pasilloID = ? and moduloID = ?;";
        $this->db->query($sql_posicion, array($pasilloID, $moduloID));
        
        $sql_nivel = "DELETE FROM nivel where pasilloID = ? and moduloID = ?;";
        $this->db->query($sql_nivel, array($pasilloID, $moduloID));
        
        $sql_modulo = "DELETE FROM modulo where pasilloID = ? and moduloID = ?;";
        $this->db->query($sql_modulo, array($pasilloID, $moduloID));
        
        $this->db->trans_complete();
    }
    
    function checkUbicacion($id)
    {
        $sql = "SELECT * FROM posicion p
join pasillo a using(pasilloID)
where pasilloTipo = 1 and id = ?;";

        $query = $this->db->query($sql, $id);
        return $query->num_rows();
    }
    
    function getPasilloTipoByUbicacion($ubicacion)
    {
        $sql = "SELECT pasilloTipo FROM posicion p join pasillo o using(pasilloID) where ubicacion = ?;";
        $query = $this->db->query($sql, $ubicacion);
        $row = $query->row();
        return $row->pasilloTipo;
    }
    
    function asignaUbicacion($ubicacion, $id, $minimo, $maximo)
    {
        $pasilloTipo = $this->getPasilloTipoByUbicacion($ubicacion);
        
        if(($id == 0 && $pasilloTipo != 3) || $pasilloTipo == 2)
        {
            $this->db->update('posicion', array('id' => $id, 'minimo' => $minimo, 'maximo' => $maximo), array('ubicacion' => $ubicacion));
            echo $this->db->affected_rows();
        }else{
            
           
            if($this->checkUbicacion($id) == 0)
            {
                $this->db->update('posicion', array('id' => $id), array('ubicacion' => $ubicacion));
                echo $this->db->affected_rows();
            }
            else{
                echo 0;
            }        
        
        }

        
    }
    
    function getPasillos()
    {
        $sql= "SELECT * FROM pasillo p
join area a using(areaID)
where a.clvsucursal = ?;";

        $query = $this->db->query($sql, array($this->session->userdata('clvsucursal')));
        
        return $query;
    }

    function getSucursalesByDiaped()
    {
        $sql = "SELECT s.clvsucursal, descsucursal, calle, colonia, cp, municipio, tiposucursalDescripcion, nivelatenciondescripcion, jurisdiccion, diaDescripcion, IFNULL(movimientoID, 0) as movimientoID
        FROM sucursales s
        join dia d on s.diaped = d.dia
        join jurisdiccion j using(numjurisd)
        join temporal_nivel_atencion n using(nivelAtencion)
        join sucursales_tipo t using(tiposucursal)
        left join movimiento_prepedido_control c on s.clvsucursal = c.clvsucursal and c.fechaPedido = DATE(NOW())
        where activa = 1 and tiposucursal = 1 and diaped = WEEKDAY(NOW());";
        $query = $this->db->query($sql);

        return $query;
    }

    function calculaPedidoBuffer($clvsucursal)
    {
        $sql = "SELECT clvsucursal, id, cvearticulo, clave, susa, descripcion, pres, sum(ifnull(cantidad, 0)) as inventario, buffer, ifnull(sum(ifnull(cantidad, 0)) / buffer, 0) * 100 as factor, case when sum(ifnull(cantidad, 0)) / buffer <.7 then buffer-sum(ifnull(cantidad, 0)) else 0 end as pedido
FROM articulos a
left join buffer b using(id)
left join inventario i using(id, clvsucursal)
where clvsucursal = ? and activo = 1
group by id
order by cvearticulo * 1;";
        
        $query = $this->db->query($sql, array($clvsucursal));

        return $query;
    }
    
    function calculaPedidoAlmacen($tipoprod = null)
    {
        $suministro = null;

        if($tipoprod <> null)
        {
            $suministro = ' WHERE a.tipoprod = ' . $tipoprod;
        }
        $sql = "SELECT a.id, cvearticulo, susa, descripcion, pres, ceil(ifnull((bufferFarmacias / 21) * 60, 0)) as bufferFarmacias,
ifnull(sum(cantidad), 0) as inventario,
ifnull((sum(cantidad) / ceil(ifnull((bufferFarmacias / 21) * 60, 0))) * 100, 0) as factor,
case when ceil(ifnull((bufferFarmacias / 21) * 60, 0)) - ifnull(sum(cantidad), 0) > 0 and ifnull((sum(cantidad) / ceil(ifnull((bufferFarmacias / 21) * 60, 0))) * 100, 0) < 70 then ceil(ifnull((bufferFarmacias / 21) * 60, 0)) - ifnull(sum(cantidad), 0) else 0 end as pedido,
case when (ceil(ifnull((bufferFarmacias / 21) * 60, 0)) - ifnull(sum(cantidad), 0) < 0) and ifnull((sum(cantidad) / ceil(ifnull((bufferFarmacias / 21) * 60, 0))) * 100, 0) > 150 then (ceil(ifnull((bufferFarmacias / 21) * 60, 0)) - ifnull(sum(cantidad), 0)) * -1 else 0 end as excedente,
case when (ceil(ifnull((bufferFarmacias / 21) * 60, 0)) = 0) and  ifnull(sum(cantidad), 0) > 0 then (ceil(ifnull((bufferFarmacias / 21) * 60, 0)) - ifnull(sum(cantidad), 0)) * -1 else 0 end as sobrante, suministro
FROM articulos a
left join inventario i on a.id = i.id and i.clvsucursal = ?
left join bufferFarmacias b on a.id = b.id
left join temporal_suministro s on a.tipoprod = s.cvesuministro
$suministro
group by a.id
order by tipoprod, cvearticulo * 1;";
        
        $query = $this->db->query($sql, array(ALMACEN));

        return $query;
    }

    function getUbicacion()
    {
        $sql = "SELECT *, clave, clvsucursal, susa, descripcion, pres
FROM ubicacion u
left join articulos a using(id)
where clvsucursal = ?;";
        
        $query = $this->db->query($sql, array($this->session->userdata('clvsucursal')));

        return $query;
    }

    function getCaducadosFarmacias()
    {
        $sql = "SELECT clvsucursal, descsucursal, id, cvearticulo, susa, descripcion, pres, lote, caducidad, cantidad, ean, marca
FROM inventario i
join sucursales s using(clvsucursal)
join articulos a using(id)
where cantidad > 0 and caducidad <= date(now()) and clvsucursal <> ?
order by clvsucursal, clvsucursal *1;";

        $query = $this->db->query($sql, array(ALMACEN));

        return $query;
    }

    function verificaInveantarioPasillo($pasilloID)
    {
        $sql = "SELECT *
FROM ubicacion u
join articulos a using(id)
join inventario i using(id, ubicacion)
where pasilloID = ? and cantidad > 0;";

        $query = $this->db->query($sql, array($pasilloID));

        return $query;
    }

    function getMovimientos()
    {
        $sql = "SELECT movimientoID, fechaCierre, referencia, tipoMovimientoDescripcion, subtipoMovimientoDescripcion, statusMovimiento, statusMovimientoDescripcion, nombreusuario, ifnull(sum(piezas), 0) as piezas
FROM movimiento m
left join movimiento_detalle d using(movimientoID)
join tipo_movimiento t using(tipoMovimiento)
join subtipo_movimiento b using(subtipoMovimiento)
join movimiento_status a using(statusMovimiento)
join usuarios u using(usuario)
where m.clvsucursal = ?
group by movimientoID
order by movimientoID desc;";

        $query = $this->db->query($sql, array($this->session->userdata('clvsucursal')));

        return $query;
    }

    function getPedidoBufferNuevo($clvsucursal, $movimientoID)
    {
        $sql = "SELECT clvsucursal, a.id, cvearticulo, susa, descripcion, pres, ifnull(buffer, 0) as buffer, ifnull(cantidad, 0) as inv, ifnull(demanda, 0) as demanda, case when c.nivelatencion is null then 0 else 1 end as cobertura, m.piezas as pedido
FROM articulos a
left join buffer b using(id)
left join sucursales s using(clvsucursal)
left join cobertura c using(id, nivelatencion)
left join inv i using(id, clvsucursal)
left join demandaCalculada d using(id, clvsucursal)
left join movimiento_prepedido m on a.id = m.id and m.movimientoID = ?
where clvsucursal = ?
order by tipoprod, cvearticulo * 1;";

        $query = $this->db->query($sql, array( $movimientoID, $clvsucursal));

        return $query;
    }

    function cargaPedidoInvVSBuffer($movimientoID)
    {
        $sql = "SELECT clvsucursal, id, cvearticulo, susa, descripcion, pres, ifnull(buffer, 0) as buffer, ifnull(cantidad, 0) as inv, ifnull(demanda, 0) as demanda, case when c.nivelatencion is null then 0 else 1 end as cobertura, ifnull(buffer, 0) - ifnull(cantidad, 0) as pedido
FROM articulos a
left join buffer b using(id)
left join sucursales s using(clvsucursal)
left join cobertura c using(id, nivelatencion)
left join inv i using(id, clvsucursal)
left join demandaCalculada d using(id, clvsucursal)
where clvsucursal = ?
having cobertura = 1 and buffer > 0 and buffer - inv > 0
order by tipoprod, cvearticulo * 1;";
        
        $query = $this->db->query($sql, array($this->session->userdata('clvsucursal')));

        $a = array();

        foreach ($query->result() as $row) {
            $b = array('movimientoID' => $movimientoID, 'id' => $row->id, 'piezas' => $row->pedido);
            array_push($a, $b);
        }

        $this->db->insert_batch('movimiento_prepedido', $a);
    }

    function guardaPrepedidoID($id, $movimientoID, $pedido)
    {
        $this->db->where('id', $id);
        $this->db->where('movimientoID', $movimientoID);
        $query = $this->db->get('movimiento_prepedido');

        if($query->num_rows() == 0)
        {
            $data = array('movimientoID' => $movimientoID, 'id' => $id, 'piezas' => $pedido);
            $this->db->insert('movimiento_prepedido', $data);
        }else
        {
            $data = array('piezas' => $pedido);
            $this->db->update('movimiento_prepedido', $data, array('movimientoID' => $movimientoID, 'id' => $id));
        }
    }
    
 //////////////////////////////////////////////////////////////////////////////////////////////////////////////
 
 function getTotalesmovimiento()
    {
        $sql = "SELECT tipoMovimientoDescripcion,subtipoMovimientoDescripcion,count(*) as total FROM movimiento a
                join tipo_movimiento b on b.tipoMovimiento = a.tipoMovimiento
                join subtipo_movimiento c on c.subtipoMovimiento = a.subtipoMovimiento
                where a.tipoMovimiento = 2
                group by a.subtipoMovimiento;";
        
        $query = $this->db->query($sql);

        return $query;
    }
    
}
    