<?php if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Movimiento extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();

        if (!Current_User::user()) {
            redirect('welcome');
        }

        $this->load->model('movimiento_model');
        $this->load->helper('utilities');

    }
    
    function index($tipoMovimiento, $subtipoMovimiento)
    {
        $this->load->library('pagination');
        $data['subtitulo'] = "Movimientos: " . $this->movimiento_model->getTitulosByTipoSubtipo($tipoMovimiento, $subtipoMovimiento);
        $data['tipoMovimiento'] = $tipoMovimiento;
        $data['subtipoMovimiento'] = $subtipoMovimiento;
        
        $config['base_url'] = site_url('movimiento/index/'.$tipoMovimiento.'/'.$subtipoMovimiento);
        $config['total_rows'] = $this->movimiento_model->getMovimientosCuenta($tipoMovimiento, $subtipoMovimiento);
        $config['per_page'] = 50;
        $config['uri_segment'] = 5;
        
        $data['query'] = $this->movimiento_model->getMovimientos($tipoMovimiento, $subtipoMovimiento, $config['per_page'], $this->uri->rsegment(5));
        $data['js'] = 'movimiento/index_js';

        $this->pagination->initialize($config); 
        
        $this->load->view('main', $data);
    }

    function asigna($movimientoID)
    {
        $data['subtitulo'] = "Movimientos: Asigna surtidor";
        $data['movimientoID'] = $movimientoID;
        $data['surtidor'] = $this->util->getSurtidoresCombo();
        $this->session->keep_flashdata('url_anterior');
        $this->load->view('main', $data);
    }

    function asigna_submit()
    {
        $movimientoID = $this->input->post('movimientoID');
        $surtidor = $this->input->post('surtidor');
        $this->movimiento_model->asignaSurtidor($movimientoID, $surtidor);
        header('Location: '. $this->session->flashdata('url_anterior'));
    }

    function buscar()
    {
    	$data['subtitulo'] = "Movimientos: Busqueda";
    	$data['js'] = 'reportes/salidas_js';
    	$this->load->view('main', $data);
    }

    function resultado_busqueda()
    {
    	$movimientoID = $this->input->post('movimientoID');
    	$referencia = $this->input->post('referencia');
    	$clvsucursalReferencia = $this->input->post('clvsucursal');
    	$data['subtitulo'] = "Movimientos: resultado de la busqueda";
    	$data['query'] = $this->movimiento_model->getBusqueda($movimientoID, $referencia, $clvsucursalReferencia);
    	$data['js'] = 'movimiento/index_js';
    	$this->load->view('main', $data);
    }

    function nuevo($tipoMovimiento, $subtipoMovimiento)
    {
        if(PATENTE == 1)
        {
            $this->util->actArticulo();
        }
        
        $data['subtitulo'] = "Nuevo Movimiento: " . $this->movimiento_model->getTitulosByTipoSubtipo($tipoMovimiento, $subtipoMovimiento);
        $data['tipoMovimiento'] = $tipoMovimiento;
        $data['subtipoMovimiento'] = $subtipoMovimiento;
        $data['sucursales'] = $this->util->getSucursalesCombo();
        $data['proveedores'] = $this->util->getProveedorCombo();
        $data['programa'] = $this->util->getProgramaCombo();
        $data['proveedoresOrigen'] = $this->util->getProveedorOrigenCombo();
        $data['validaUbicacion'] = $this->util->getValidaUbicacion($tipoMovimiento);


        $data['js'] = "movimiento/nuevo_js";
        $this->load->view('main', $data);
    }
    
    function actualizaArticulo()
    {
        $this->util->actArticulo();
        echo "Listo";
        echo "<br />";
        echo "Cierra esta ventana";
    }
    
    function nuevo_submit()
    {
        $tipoMovimiento = $this->input->post('tipoMovimiento');
        $subtipoMovimiento = $this->input->post('subtipoMovimiento');
        $fecha = $this->input->post('fecha');
        $fecha = $this->input->post('fecha');
        $orden = $this->input->post('orden');
        $referencia = $this->input->post('referencia');
        $referenciaOrigen = $this->input->post('referenciaOrigen');
        $remision = $this->input->post('remision');
        $sucursal_referencia = $this->input->post('sucursal_referencia');
        $proveedor = $this->input->post('proveedor');
        $proveedorOrigen = $this->input->post('proveedorOrigen');
        $observaciones = $this->input->post('observaciones');
        $idprograma = $this->input->post('idprograma');
        $colectivo = $this->input->post('colectivo');
        
        $this->movimiento_model->insertMovimiento($tipoMovimiento, $subtipoMovimiento, $fecha, $orden, $referencia, $sucursal_referencia, $proveedor, $observaciones, $remision, $idprograma, $colectivo, $referenciaOrigen, $proveedorOrigen);
        redirect('movimiento/index/'.$tipoMovimiento.'/'.$subtipoMovimiento);
    }
    
    function edita($movimientoID)
    {
        $data['subtitulo'] = "Nuevo Movimiento";
        $data['sucursales'] = $this->util->getSucursalesCombo();
        $data['proveedores'] = $this->util->getProveedorCombo();
        $data['query'] = $this->movimiento_model->getMovimiento($movimientoID);
        $data['programa'] = $this->util->getProgramaCombo();
        $data['js'] = "movimiento/nuevo_js";
        $this->load->view('main', $data);

    }

    function edita_submit()
    {
        $movimientoID = $this->input->post('movimientoID');
        $tipoMovimiento = $this->input->post('tipoMovimiento');
        $subtipoMovimiento = $this->input->post('subtipoMovimiento');
        $fecha = $this->input->post('fecha');
        $fecha = $this->input->post('fecha');
        $orden = $this->input->post('orden');
        $referencia = $this->input->post('referencia');
        $sucursal_referencia = $this->input->post('sucursal_referencia');
        $proveedor = $this->input->post('proveedor');
        $observaciones = $this->input->post('observaciones');
        $idprograma = $this->input->post('idprograma');
        
        $this->movimiento_model->updateMovimiento($tipoMovimiento, $subtipoMovimiento, $fecha, $orden, $referencia, $sucursal_referencia, $proveedor, $observaciones, $idprograma, $movimientoID);
        redirect('movimiento/index/'.$tipoMovimiento.'/'.$subtipoMovimiento);
    }

    function captura($movimientoID)
    {
        $this->load->model('Catalogosweb_model');
        $data['subtitulo'] = "Captura de Movimiento";
        $data['sucursales'] = $this->util->getSucursalesCombo();
        $data['proveedores'] = $this->util->getProveedorCombo();
        $data['query'] = $this->movimiento_model->getMovimientoByMovimientoID($movimientoID);

        $data['cronico'] = $this->Catalogosweb_model->getCronico();
        $data['grupo'] = $this->Catalogosweb_model->getGrupo();
        $data['laboratorio'] = $this->Catalogosweb_model->getLaboratorio();
        $data['presentacion'] = $this->Catalogosweb_model->getPresentacion();
        $data['susa'] = $this->Catalogosweb_model->getRelacional();
        $data['restriccion'] = $this->Catalogosweb_model->getRestriccion();
        $data['unidad'] = $this->Catalogosweb_model->getUnidad();
        $data['cuadro'] = $this->Catalogosweb_model->getCuadro();
        $data['relacional_grupos'] = $this->Catalogosweb_model->getRelacionalGrupo();            
        $data['relacional_sales'] = $this->Catalogosweb_model->getRelacionalSal();            

        $data['json'] = $this->movimiento_model->getMarcas();
        $data['js'] = "movimiento/captura_js";
        $this->load->view('main', $data);
    }
    
    function surtido_dinamico($movimientoID)
    {
        $this->load->library('pagination');
        $data['subtitulo'] = "SurtidoDinamico: " . $movimientoID;
        
        $config['base_url'] = site_url('movimiento/surtido_dinamico/'.$movimientoID);
        $config['total_rows'] = $this->movimiento_model->getSurtidoDinamicoCuenta($movimientoID);
        $config['next_link'] = 'Siguiente';
        $config['prev_link'] = 'Anterior';
        $config['first_link'] = 'Primero';
        $config['last_link'] = 'Ultimo';
        $config['per_page'] = 1;
        $config['uri_segment'] = 4;
        $data['registro'] = $this->uri->rsegment(4);
        $data['movimientoID'] = $movimientoID;
        
        $data['query'] = $this->movimiento_model->getSurtidoDinamico($movimientoID, $config['per_page'], $this->uri->rsegment(4));
        $data['js'] = 'movimiento/surtido_dinamico_js';
        $data['dinamico'] = $this->session->flashdata('dinamico'); 

        $this->pagination->initialize($config); 
        
        $this->load->view('main', $data);
    }

    function surtido_dinamico_resumen($movimientoID)
    {
        $data['subtitulo'] = "Resumen de captura";
        $data['query'] = $this->movimiento_model->getSurtidoDinamicoResumen($movimientoID);
        //$data['js'] = "movimiento/captura_js";
        $this->load->view('main', $data);
    }

    function sutido_dinamico_cansur()
    {
    	$inventarioID = $this->input->post('inventarioID');
    	$cansur = $this->input->post('cansur');
    	$movimientoID = $this->input->post('movimientoID');

    	echo $this->movimiento_model->surtidoDinamicoCaptura($inventarioID, $cansur, $movimientoID);
    }

    function surtido_dinamico_eliminar($movimientoDetalle)
    {
    	echo $this->movimiento_model->deleteSurtidoDinamico($movimientoDetalle);
    }

    function validaArea()
    {
        $movimientoID = $this->input->post('movimientoID');
        $areaID = $this->input->post('areaID');
        
        redirect('movimiento/transfer/'.$movimientoID.'/'.$areaID);
    }
    
    function transfer($movimientoID, $areaID)
    {
        $data['subtitulo'] = "Captura de Transferencia";
        $data['areaID'] = $areaID;
        $data['movimientoID'] = $movimientoID;
        
        $data['areas'] = $this->movimiento_model->getAreaIDDropdown();
        $data['query'] = $this->movimiento_model->getMovimientoByMovimientoID($movimientoID);
        $data['query2'] = $this->movimiento_model->getInventarioBySubtipoMovimiento($movimientoID, $areaID);
        
        
        //$data['json'] = json_encode($this->util->getDataOficina('laboratorio', array()));
        $data['js'] = "movimiento/transfer_js";
        $this->load->view('main', $data);
    }
    
    function transferParcial()
    {
        $movimientoID = $this->input->post('movimientoID');
        $inventarioID = $this->input->post('inventarioID');
        $valor = $this->input->post('valor');
        
        $this->movimiento_model->transferAplica($movimientoID, $inventarioID, $valor);
    }
    
    function prepedido($movimientoID)
    {
        $data['subtitulo'] = "Pre-pedido";
        //$data['sucursales'] = $this->util->getSucursalesCombo();
        //$data['proveedores'] = $this->util->getProveedorCombo();
        $data['query'] = $this->movimiento_model->getMovimientoByMovimientoID($movimientoID);
        //$data['json'] = json_encode($this->util->getDataOficina('laboratorio', array()));
        $data['js'] = "movimiento/prepedido_js";
        $this->load->view('main', $data);
    }

    function cambiar($movimientoDetalle)
    {
        $data['subtitulo'] = "Cambiar";
        $data['query'] = $this->movimiento_model->getDetalleByMovimientoDetalle($movimientoDetalle);
        $this->load->view('main', $data);
    }

    function cambiar_submit()
    {
        $movimientoDetalle = $this->input->post('movimientoDetalle');
        $piezasNueva = $this->input->post('piezasNueva');
        $movimientoID = $this->movimiento_model->cambioDetalle($movimientoDetalle, $piezasNueva);
        redirect('movimiento/captura/' . $movimientoID);
    }

    function busca_articulo()
    {
        $term = $this->input->get_post('term');
        echo $this->movimiento_model->getArticulosJSON($term);
    }

    function busca_ean()
    {
        $term = $this->input->get_post('term');
        echo $this->movimiento_model->getEanJSON($term);
    }    
    
    function busca_articulo_salida($nivelatencionReferencia = 2, $cobertura = 100, $subtipoMovimiento = null)
    {
        $term = $this->input->get_post('term');
        echo $this->movimiento_model->getArticulosJSONSalida($term, $nivelatencionReferencia, $cobertura, $subtipoMovimiento);
    }

    function busca_proveedor()
    {
        $term = $this->input->get_post('term');
        echo $this->movimiento_model->getProveedorJSON($term);
    }

    function busca_sucursal()
    {
        $term = $this->input->get_post('term');
        echo $this->movimiento_model->getSucursalJSON($term);
    }

    function articuloValida()
    {
        $articulo = $this->input->post('articulo');
        $orden = $this->input->post('orden');
        $ean = $this->input->post('ean');
        echo $this->movimiento_model->getArticuloDatos($articulo, $orden);
    }
    
    function articuloValidaSalida()
    {
        $articulo = $this->input->post('articulo');
        $nivelatencionReferencia = $this->input->post('nivelatencionReferencia');
        $cobertura = $this->input->post('cobertura');
        $subtipoMovimiento = $this->input->post('subtipoMovimiento');

        echo $this->movimiento_model->getArticuloDatosSalida($articulo, $nivelatencionReferencia, $cobertura, $subtipoMovimiento);
    }

    function getEANMarca()
    {
        $ean = $this->input->post('ean');
        echo $this->movimiento_model->getMarca($ean);
    }
    
    function detalle()
    {
        $movimientoID = $this->input->post('movimientoID');
        $data['query'] = $this->movimiento_model->getDetalle($movimientoID);
        $data['movimientoID'] = $movimientoID;
        $this->load->view('movimiento/detalle', $data);
    }
    
    function detallePrepedido()
    {
        $movimientoID = $this->input->post('movimientoID');
        $data['query'] = $this->movimiento_model->getDetallePrepedido($movimientoID);
        $data['movimientoID'] = $movimientoID;
        $this->load->view('movimiento/detallePrepedido', $data);
    }

    function modifica($movimientoDetalle, $movimientoID)
    {
        $data['subtitulo'] = "Modificar clave de entrada";
        $data['query'] = $this->movimiento_model->getDetalleByMovimientoDetalle($movimientoDetalle);
        $data['movimientoID'] = $movimientoID;
        $this->load->view('main', $data);
    }
    
    function modifica_submit()
    {
        $movimientoID = $this->input->post('movimientoID');
        $movimientoDetalle = $this->input->post('movimientoDetalle');
        $piezas = $this->input->post('piezas');
        $costo = $this->input->post('costo');
        $lote = $this->input->post('lote');
        $caducidad = $this->input->post('caducidad');
        $ean = $this->input->post('ean');
        $marca = $this->input->post('marca');
        
        $data = array(
            'piezas' => $piezas,
            'costo' => $costo,
            'lote' => $lote,
            'caducidad' => $caducidad,
            'ean' => $ean,
            'marca' => $marca
            );
            
        $this->movimiento_model->modificaDetalle($data, $movimientoDetalle);
        redirect('movimiento/captura/'.$movimientoID);

    }

    function elimina_detalle($movimientoDetalle)
    {
        $this->movimiento_model->eliminaDetalle($movimientoDetalle);
    }
    
    function elimina_detalle_prepedido($movimientoPrepedido)
    {
        $this->movimiento_model->eliminaDetallePrepedido($movimientoPrepedido);
    }

    function cargaLotes()
    {
        $articulo = $this->input->post('articulo');
        $subtipoMovimiento = $this->input->post('subtipoMovimiento');
        
        if($subtipoMovimiento == 6 || $subtipoMovimiento == 7)
        {
            $query = $this->movimiento_model->getLotes($articulo);
        }else{
            $query = $this->movimiento_model->getLotes($articulo);
        }
        
        
        
        $a = null;
        
        foreach($query->result() as $row)
        {
            $a .= '<option value="'.$row->inventarioID.'">'.$row->lote.' - '.$row->caducidad.' ('.$row->cantidad.') - '.$row->area.' - '.$row->pasillo.'</option>
            ';
        }
        
        echo $a;
    }
    
    function cargaLotesOpcion2()
    {
        $articulo = $this->input->post('articulo');
        $query = $this->movimiento_model->getLotes($articulo);
        
        $a = '<option value="TODOS">TODOS</option>
        ';
        
        foreach($query->result() as $row)
        {
            $a .= '<option value="'.$row->lote.'">'.$row->lote.' - '.$row->caducidad.' ('.$row->cantidad.')</option>
            ';
        }
        
        echo $a;
    }

    function captura_submit()
    {
        $movimientoID = $this->input->post('movimientoID');
        $articulo = $this->input->post('articulo');
        $piezas = $this->input->post('piezas');
        $lote = $this->input->post('lote');
        $caducidad = $this->input->post('caducidad');
        $ean = $this->input->post('ean');
        $costo = $this->input->post('costo');
        $costoOrigen = $this->input->post('costoOrigen');        
        $ubicacion = $this->input->post('ubicacion');
        
        $var1 = explode('|', $articulo);
        $id = $var1[0];
        
        $this->movimiento_model->insertDetalle($movimientoID, $id, $piezas, $costo, $lote, $caducidad, $ean, $ubicacion, $costoOrigen);
        
    }
    
    function captura_submit2()
    {
        $movimientoID = $this->input->post('movimientoID');
        $inventarioID = $this->input->post('inventarioID');
        $piezas = $this->input->post('piezas');
        
        $this->movimiento_model->insertDetalle2($movimientoID, $inventarioID, $piezas);
        
    }
    
    function captura_submit3()
    {
        $cveArticulo = $this->input->post('cvearticulo');
        $movimientoID = $this->input->post('movimientoID');
        $piezas = $this->input->post('piezas');
        
        $this->movimiento_model->insertDetalle3($movimientoID, $cveArticulo, $piezas);
        
    }

    function cierrePrepedido($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
        $this->movimiento_model->cierrePrepedido($movimientoID);
        redirect('movimiento/index/'.$tipoMovimiento.'/'.$subtipoMovimiento);
    }
    
    function evaluaCierre($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
        $sql = "SELECT m.movimientoDetalle, m.movimientoID, m.id, sum(m.piezas) as piezas, m.costo, m.lote, m.caducidad, m.ean, m.marca, ifnull(i.cantidad, 'NADA') as cantidad, o.tipoMovimiento, o.subtipoMovimiento, inventarioID, m.ubicacion, m.comercial
FROM movimiento_detalle m
join movimiento o using(movimientoID)
left join inventario i on m.id = i.id and m.lote = i.lote and m.ubicacion = i.ubicacion and i.clvsucursal = ?
where m.movimientoID = ? and piezas > 0
group by id, lote, i.ubicacion
having piezas > cantidad
limit 1;";
        
        $query = $this->db->query($sql, array($this->session->userdata('clvsucursal'), $movimientoID));
        
        if($query->num_rows() == 1)
        {
            $row = $query->row();
            
            $this->session->set_flashdata('error', 'El detalle: ' . $row->movimientoDetalle . ', no se puede cerrar debido a que la salida ' . $row->piezas . ' es mayor a la cantidad en el inventario ' . $row->cantidad . ', en el lote: ' .$row->lote . '.');
            
            redirect('movimiento/captura/'.$movimientoID);
        }
        
    }

    function cierre($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
        if($tipoMovimiento == 2)
        {
            $this->evaluaCierre($movimientoID, $tipoMovimiento, $subtipoMovimiento);
        }
        
        $this->db->trans_start();
        
        if($subtipoMovimiento == 15)
        {
            $sql_pon_a_cero = "update 
            inventario 
            set cantidad = 0, tipoMovimiento = ?, subtipoMovimiento = ?, ultimo_movimiento = now(), receta = 0, movimientoID = ?, usuario = ? 
            where clvsucursal = ? and cantidad <> 0;";
            $this->db->query($sql_pon_a_cero, array($tipoMovimiento, $subtipoMovimiento, $movimientoID, $this->session->userdata('usuario'), $this->session->userdata('clvsucursal')));
            
        }
        
        $sql1 = "SELECT m.movimientoDetalle, m.movimientoID, m.id, sum(case when o.subtipoMovimiento = 27 then m.piezas * numunidades else m.piezas end) as piezas, case when o.subtipoMovimiento = 27 then m.costo/numunidades else m.costo end as costo, m.lote, m.caducidad, m.ean, m.marca, ifnull(i.cantidad, 'NADA') as cantidad, o.tipoMovimiento, o.subtipoMovimiento, inventarioID, m.ubicacion, m.comercial, m.descontado, numunidades
FROM movimiento_detalle m
join movimiento o using(movimientoID)
join articulos a using(id)
left join inventario i on m.id = i.id and m.lote = i.lote and m.ubicacion = i.ubicacion and i.clvsucursal = ?
where m.movimientoID = ? and piezas > 0 and statusMovimiento = 0
group by id, lote, i.ubicacion;";
        
        $query1 = $this->db->query($sql1, array($this->session->userdata('clvsucursal'), $movimientoID));
        
        foreach($query1->result() as $row1)
        {
            if($row1->cantidad == 'NADA')
            {
                if((int)$row1->tipoMovimiento == 1)
                {
                    $data = array(
                        'id' => $row1->id,
                        'lote' => $row1->lote,
                        'caducidad' => $row1->caducidad,
                        'cantidad' => $row1->piezas,
                        'tipoMovimiento' => $row1->tipoMovimiento,
                        'subtipoMovimiento' => $row1->subtipoMovimiento,
                        'receta' => 0,
                        'usuario' => $this->session->userdata('usuario'),
                        'movimientoID' => $row1->movimientoID,
                        'ean' => $row1->ean,
                        'marca' => $row1->marca,
                        'costo' => $row1->costo,
                        'clvsucursal' => $this->session->userdata('clvsucursal'),
                        'ubicacion' => $row1->ubicacion,
                        'comercial' => $row1->comercial
                        );
                    
                    $this->db->set('ultimo_movimiento', 'now()', false);
                    $this->db->insert('inventario', $data);
                    
                }elseif((int)$row1->tipoMovimiento == 2)
                {
                    $cantidad  = ((int)0 - (int)$row1->piezas);
                    $data = array(
                        'id' => $row1->id,
                        'lote' => $row1->lote,
                        'caducidad' => $row1->caducidad,
                        'cantidad' => $cantidad,
                        'tipoMovimiento' => $row1->tipoMovimiento,
                        'subtipoMovimiento' => $row1->subtipoMovimiento,
                        'receta' => 0,
                        'usuario' => $this->session->userdata('usuario'),
                        'movimientoID' => $row1->movimientoID,
                        'clvsucursal' => $this->session->userdata('clvsucursal'),
                        'ubicacion' => $row1->ubicacion,
                        'comercial' => $row1->comercial
                        );
                        
                    $this->db->set('ultimo_movimiento', 'now()', false);
                    $this->db->insert('inventario', $data);
                    
                }
            }else{
                if((int)$row1->tipoMovimiento == 1)
                {
                    $cantidad = ((int)$row1->cantidad + (int)$row1->piezas);
                    $data = array(
                        'id' => $row1->id,
                        'lote' => $row1->lote,
                        'caducidad' => $row1->caducidad,
                        'cantidad' => $cantidad,
                        'tipoMovimiento' => $row1->tipoMovimiento,
                        'subtipoMovimiento' => $row1->subtipoMovimiento,
                        'receta' => 0,
                        'usuario' => $this->session->userdata('usuario'),
                        'movimientoID' => $row1->movimientoID,
                        'ean' => $row1->ean,
                        'marca' => $row1->marca,
                        'costo' => $row1->costo,
                        'clvsucursal' => $this->session->userdata('clvsucursal'),
                        'ubicacion' => $row1->ubicacion,
                        'comercial' => $row1->comercial
                        );
                        
                    $this->db->set('ultimo_movimiento', 'now()', false);
                    $this->db->update('inventario', $data, array('inventarioID' => $row1->inventarioID));

                }elseif((int)$row1->tipoMovimiento == 2 && $row1->descontado == 0)
                {
                    $cantidad = ((int)$row1->cantidad - (int)$row1->piezas);
                    $data = array(
                        'id' => $row1->id,
                        'lote' => $row1->lote,
                        'caducidad' => $row1->caducidad,
                        'cantidad' => $cantidad,
                        'tipoMovimiento' => $row1->tipoMovimiento,
                        'subtipoMovimiento' => $row1->subtipoMovimiento,
                        'receta' => 0,
                        'usuario' => $this->session->userdata('usuario'),
                        'movimientoID' => $row1->movimientoID,
                        'clvsucursal' => $this->session->userdata('clvsucursal'),
                        'ubicacion' => $row1->ubicacion,
                        'comercial' => $row1->comercial
                        );
                        
                    $this->db->set('ultimo_movimiento', 'now()', false);
                    $this->db->update('inventario', $data, array('inventarioID' => $row1->inventarioID));
                }
            }
            
            
            if((int)$row1->subtipoMovimiento == 1 || (int)$row1->subtipoMovimiento == 2 || (int)$row1->subtipoMovimiento == 3)
            {
                if((float)$row1->costo > 0)
                {
                    $data3 = array('ultimo_costo' => $row1->costo);
                    $this->db->update('articulos', $data3, array('id' => $row1->id));
                    
                }
            }
            
        }
        
        if((int)$subtipoMovimiento == 1)
        {
            $folio = $this->util->getDataOficina('folio', array('foliador' => $this->session->userdata('cxp')));
        }else{
            $folio = new StdClass();
            $folio->folio = 0;
        }
        
        
        $data2  = array('statusMovimiento' => 1, 'nuevo_folio' => $folio->folio, 'fechaCierre' => FECHAYHORA);
        $this->db->update('movimiento', $data2, array('movimientoID' => $movimientoID));

        if($subtipoMovimiento == 22)
        {
            $dataColectivo = array('statusColectivo' => 3);
            $this->db->update('colectivo', $dataColectivo, array('movimientoID' => $movimientoID));
        }
        
        
        
        $this->db->trans_complete();
        
        
        if ($this->db->trans_status() === TRUE)
        {
            if($subtipoMovimiento == 1 || $subtipoMovimiento == 3)
            {
                $json = $this->util->getOrdenPostJson($movimientoID);
                $res = $this->util->postDataOficina('orden', $json);
            
                if($res == null)
                {
                    
                }else{
                    $this->db->update('movimiento', array('aplicada' => 1), array('movimientoID' => $movimientoID));
                }
            }elseif($subtipoMovimiento == 2)
            {
                $json = $this->movimiento_model->getJSONByMovimientoID($movimientoID);
                $this->util->postDataOficina('traspaso', $json);
            }
        
            //$this->util->postMovimiento($movimientoID);
            //$this->util->postInventario();// generate an error... or use the log_message() function to log your error
        } 
        
        
        redirect('movimiento/index/'.$tipoMovimiento.'/'.$subtipoMovimiento);
        
    }

    function pruebaTraspaso()
    {
        $json = $this->movimiento_model->getJSONByMovimientoID(807);
        $res = $this->util->postDataOficina('traspaso', $json);
    }

    function imprime($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
        set_time_limit(0);
        ini_set('memory_limit','-1');

        $data['header'] = $this->movimiento_model->header($movimientoID);
        //$data['detalle1'] = $this->pedidos_model->pedido_embarque($id);
        $data['detalle'] = $this->movimiento_model->detalle($movimientoID);/*HOJA DE PEDIDO */
        $data['formato'] = $this->movimiento_model->formato01($movimientoID);/*HOJA DE EMBARQUE*/
        $data['formato1'] = $this->movimiento_model->formato02($movimientoID);/*HOJA DE DEVOLUCIONES*/
        $data['tipoMovimiento'] = $tipoMovimiento;
        $data['movimientoID'] = $movimientoID;
        $data['subtipoMovimiento'] = $subtipoMovimiento;
      
        $this->load->view('impresiones/movimiento', $data);
    }

    function imprimeExcedente($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
        set_time_limit(0);
        ini_set('memory_limit','-1');

        $data['header'] = $this->movimiento_model->headerExcedente($movimientoID);
        //$data['detalle1'] = $this->pedidos_model->pedido_embarque($id);
        $data['detalle'] = $this->movimiento_model->detalleExcedente($movimientoID);/*HOJA DE PEDIDO */
        $data['tipoMovimiento'] = $tipoMovimiento;
        $data['movimientoID'] = $movimientoID;
        $data['subtipoMovimiento'] = $subtipoMovimiento;
      
        $this->load->view('impresiones/movimientoExcedente', $data);
    }

    function guia($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
        //set_time_limit(0);
        //ini_set('memory_limit','-1');
        $this->movimiento_model->fillPrepedidoUbicacion($movimientoID);
        $data['header'] = $this->movimiento_model->header($movimientoID);
        //$data['detalle1'] = $this->pedidos_model->pedido_embarque($id);
        //$data['detalle'] = $this->movimiento_model->detalle($movimientoID);/*HOJA DE PEDIDO */
        $data['detalle'] = $this->movimiento_model->getGuia($movimientoID);
        $data['tipoMovimiento'] = $tipoMovimiento;
        $data['movimientoID'] = $movimientoID;
        $data['subtipoMovimiento'] = $subtipoMovimiento;
      
        $this->load->view('impresiones/guia2', $data);
    }

    function embarque($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
        $data['subtitulo'] = "Datos de Embarque";
        $data['movimientoID'] = $movimientoID;
        $data['tipoMovimiento'] = $tipoMovimiento;
        $data['subtipoMovimiento'] = $subtipoMovimiento;
        $data['movimientoID'] = $movimientoID;
        $data['query'] = $this->movimiento_model->getEmbarque($movimientoID);
        $data['js'] = "movimiento/embarque_js";
        $this->load->view('main', $data);
    }
    
    function embarque_submit()
    {
        $movimientoID = $this->input->post('movimientoID');
        $tipoMovimiento = $this->input->post('tipoMovimiento');
        $subtipoMovimiento = $this->input->post('subtipoMovimiento');
        
        $embarco = $this->input->post('embarco');
        $operador = $this->input->post('operador');
        $unidad = $this->input->post('unidad');
        $placas = $this->input->post('placas');
        $cajas = $this->input->post('cajas');
        $hieleras = $this->input->post('hieleras');
        $surtio = $this->input->post('surtio');
        $valido = $this->input->post('valido');
        $observaciones = $this->input->post('observaciones');
        
        $this->movimiento_model->replaceEmbarque($movimientoID, $embarco, $operador, $unidad, $placas, $cajas, $hieleras, $surtio, $valido, $observaciones);
        redirect('movimiento/index/'.$tipoMovimiento.'/'.$subtipoMovimiento);
    }

    function devolucion($movimientoDetalle)
    {
        $data['subtitulo'] = "Devolucion de mercancia a paquete";
        $data['causas'] = $this->util->getDevolucionCausasCombo();
        $data['query'] = $this->movimiento_model->getDetalleByMovimientoDetalle($movimientoDetalle);
        $data['js'] = "movimiento/devolucion_js";
        $this->load->view('main', $data);
    }
    
    function devolucion_submit()
    {
        $this->db->trans_start();
        
        $movimientoID = $this->input->post('movimientoID');
        $movimientoDetalle = $this->input->post('movimientoDetalle');
        $devuelve = $this->input->post('devuelve');
        $causa = $this->input->post('causa');
        
        $data1 = array('movimientoDetalle' => $movimientoDetalle, 'devuelve' => $devuelve, 'causaID' => $causa, 'clvsucursal' => $this->session->userdata('clvsucursal'));
        
        $this->db->insert('devolucion', $data1);
        
        $query = $this->movimiento_model->getDetalleByMovimientoDetalle($movimientoDetalle);
        $row = $query->row();
        
        $piezasActuales = $row->piezas - $devuelve;
        
        $data2 = array('piezas' => $piezasActuales);
        
        $this->db->update('movimiento_detalle', $data2, array('movimientoDetalle' => $movimientoDetalle));
        
        
        $this->db->where('id', $row->id);
        $this->db->where('lote', $row->lote);
        $query3 = $this->db->get('inventario');
        
        if($query3->num_rows() > 0)
        {
            $row3 = $query3->row();

                    $data = array(
                        'id' => $row3->id,
                        'lote' => $row3->lote,
                        'caducidad' => $row3->caducidad,
                        'cantidad' => ($row3->cantidad + $devuelve),
                        'tipoMovimiento' => 1,
                        'subtipoMovimiento' => 17,
                        'receta' => 0,
                        'usuario' => $this->session->userdata('usuario'),
                        'movimientoID' => $movimientoID,
                        'ean' => $row3->ean,
                        'marca' => $row3->marca,
                        'costo' => $row3->costo,
                        'clvsucursal' => $this->session->userdata('clvsucursal')
                        );
                        
                    $this->db->update('inventario', $data, array('inventarioID' => $row3->inventarioID));
        }else{
                    $data = array(
                        'id' => $row->id,
                        'lote' => $row->lote,
                        'caducidad' => $row->caducidad,
                        'cantidad' => $devuelve,
                        'tipoMovimiento' => 1,
                        'subtipoMovimiento' => 17,
                        'receta' => 0,
                        'usuario' => $this->session->userdata('usuario'),
                        'movimientoID' => $movimientoID,
                        'ean' => $row->ean,
                        'marca' => $row->marca,
                        'costo' => $row->costo,
                        'clvsucursal' => $this->session->userdata('clvsucursal')
                        );
                    $this->db->insert('inventario', $data);
            
        }
        
        
        $this->db->trans_complete();
        
        if ($this->db->trans_status() === TRUE)
        {
            $this->util->postMovimiento($movimientoID);
            $this->util->postInventario();
        }
        
        redirect('movimiento/captura/'.$movimientoID);
        
    }
    
    function validaOrden()
    {
        $folprv = $this->input->post('orden');
        $data = $this->util->getDataOficina('orden', array('folprv' => $folprv));
        echo json_encode($data);
    }
    
    function getUbicaciones()
    {
        $cvearticulo = $this->input->post('cvearticulo');
        echo $this->util->getUbicacionesComboByClave($cvearticulo);
    }
    
    function prueba()
    {
        $this->util->postFacturar(43, 1);
    }
    
    function asigna_factura($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
        $data['subtitulo'] = "Asigna Factura";
        $data['movimientoID'] = $movimientoID;
        $data['tipoMovimiento'] = $tipoMovimiento;
        $data['subtipoMovimiento'] = $subtipoMovimiento;
        $data['js'] = "movimiento/asigna_factura_js";
        $this->load->view('main', $data);
        
    }
    
    function asigna_factura_submit()
    {
        $movimientoID = $this->input->post('movimientoID');
        $tipoMovimiento = $this->input->post('tipoMovimiento');
        $subtipoMovimiento = $this->input->post('subtipoMovimiento');
        $referencia = trim($this->input->post('referencia'));
        
        $this->movimiento_model->asignaFactura($movimientoID, $referencia);
        redirect('movimiento/index/'.$tipoMovimiento.'/'.$subtipoMovimiento);
    }
    
    function factura($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
        $data['subtitulo'] = "Facturar pedido";
        $data['clientes'] = $this->movimiento_model->getClientesByMovimientoIDCombo($movimientoID);
        $data['movimientoID'] = $movimientoID;
        $data['tipoMovimiento'] = $tipoMovimiento;
        $data['subtipoMovimiento'] = $subtipoMovimiento;
        $data['js'] = "movimiento/factura_js";
        $this->load->view('main', $data);
    }
    
    function factura_submit()
    {
        $movimientoID = $this->input->post('movimientoID');
        $tipoMovimiento = $this->input->post('tipoMovimiento');
        $subtipoMovimiento = $this->input->post('subtipoMovimiento');
        $contratoID = $this->input->post('contratoID');
        
        $query = $this->movimiento_model->getMovimientoByMovimientoID($movimientoID);
        $row = $query->row();
        
        if($row->idFactura == 0)
        {
            $this->util->postFacturar($movimientoID, $contratoID);
        }
        
        redirect('movimiento/index/'.$tipoMovimiento.'/'.$subtipoMovimiento);
    }
    
    function getContratoByCliente()
    {
        $rfc = $this->input->post('rfc');
        
        echo $this->movimiento_model->getContratoCombo($rfc);
    }
    
    function getFacturaVistaPrevia()
    {
        $this->load->model('Catalogosweb_model');
        $contratoID = $this->input->post('contratoID');
        $movimientoID = $this->input->post('movimientoID');
        $data['query'] = $this->movimiento_model->getFacturaProductosByContratoID($contratoID, $movimientoID);
        $data['referencia'] = $this->movimiento_model->getFacturaReferencia($contratoID, $movimientoID);
        $this->load->view('movimiento/facturaVistaPrevia', $data);
    }
    
    function descargaXML($movimientoID)
    {
        $query = $this->movimiento_model->getMovimientoByMovimientoID($movimientoID);
        $row = $query->row();
        
        $this->load->helper('download');
        $data = file_get_contents($row->urlxml); // Read the file's contents
        $name = 'factura_'.$row->folioFactura.'.xml';
        
        force_download($name, $data); 
    }

    function descargaPDF($movimientoID)
    {
        $query = $this->movimiento_model->getMovimientoByMovimientoID($movimientoID);
        $row = $query->row();
        
        $this->load->helper('download');
        $data = file_get_contents($row->urlpdf); // Read the file's contents
        $name = 'factura_'.$row->folioFactura.'.pdf';
        
        force_download($name, $data); 
    }

    function validaReferencia()
    {
        $referencia = $this->input->post('referencia');
        echo json_encode($this->util->getDataOficina('transitoControl', array('referencia' => $referencia)));
    }

    function getIDFromCveArticulo($cvearticulo)
    {
        $sql = "SELECT id FROM articulos a where cvearticulo = ?;";

        $query = $this->db->query($sql, array((string)$cvearticulo));

        if($query->num_rows() > 0)
        {
            $row = $query->row();
            return $row->id;
        }else
        {
            return 0;
        }
    }

    function getUbicacionAutoLlenado()
    {
        $sql = "SELECT ubicacion FROM ubicacion u where clvsucursal = ? and id = 0 order by pasilloTipo desc limit 1;";

        $query = $this->db->query($sql, array($this->session->userdata('clvsucursal')));

        if($query->num_rows() > 0)
        {
            $row = $query->row();
            return $row->ubicacion;
        }else
        {
            return 0;
        }
    }

    function getUbicacionRecibaGeneral()
    {
        $sql = "SELECT ubicacion FROM ubicacion u where clvsucursal = ? and pasilloTipo = 3;";

        $query = $this->db->query($sql, array($this->session->userdata('clvsucursal')));

        if($query->num_rows() > 0)
        {
            $row = $query->row();
            return $row->ubicacion;
        }else
        {
            return 0;
        }
    }

    function getDetalleSalida($referencia)
    {
        $sql = "SELECT d.* FROM movimiento m
join movimiento_detalle d using(movimientoID)
where tipoMovimiento = 2 and referencia = ? and clvsucursalReferencia = ?;";
        $query = $this->db->query($sql, array((string)$referencia, $this->session->userdata('clvsucursal')));

        return $query;
    }

    function getSalidaRemota()
    {
        $referencia = $this->input->post('referencia');
        $movimientoID = $this->input->post('movimientoID');

        $datos = $this->util->getDataOficina('transitoDetalle', array('referencia' => $referencia));

        if(isset($datos->error) || count($datos) == 0)
        {
            $this->getSalidaLocal($referencia, $movimientoID);
        }else
        {
            foreach ($datos as $dat) {

                $id = $this->getIDFromCveArticulo($dat->cvearticulo);

                if($id > 0)
                {

                    $this->db->where('movimientoID', $movimientoID);
                    $this->db->where('idRemoto', $dat->movimientoDetalle);

                    $q = $this->db->get('movimiento_detalle');

                    if($q->num_rows() == 0)
                    {

                        $ubicacion = $this->getUbicacionAutoLlenado();

                        if($ubicacion > 0)
                        {


                            $data = array(
                                'movimientoID'  => $movimientoID,
                                'id'            => $id,
                                'piezas'        => $dat->piezas,
                                'costo'         => $dat->costo,
                                'lote'          => (string)$dat->lote,
                                'caducidad'     => (string)$dat->caducidad,
                                'ean'           => $dat->ean,
                                'marca'         => (string)$dat->marca,
                                'ubicacion'     => $ubicacion,
                                'comercial'     => (string)$dat->comercial,
                                'idRemoto'      => $dat->movimientoDetalle
                            );

                            $this->db->insert('movimiento_detalle', $data);

                        }

                    }

                }
            }
        }



    }
    
    function getSalidaLocal($referencia, $movimientoID)
    {
        $datos = $this->getDetalleSalida($referencia);

        

 
        foreach ($datos->result() as $dat) {



            $this->db->where('movimientoID', $movimientoID);
            $this->db->where('idRemoto', $dat->movimientoDetalle);

            $q = $this->db->get('movimiento_detalle');

            if($q->num_rows() == 0)
            {

                $ubicacion = $this->getUbicacionAutoLlenado();

                echo $ubicacion;

                if($ubicacion > 0)
                {


                    $data = array(
                            'movimientoID'  => $movimientoID,
                            'id'            => $dat->id,
                            'piezas'        => $dat->piezas,
                            'costo'         => $dat->costo,
                            'lote'          => (string)$dat->lote,
                            'caducidad'     => (string)$dat->caducidad,
                            'ean'           => $dat->ean,
                            'marca'         => (string)$dat->marca,
                            'ubicacion'     => $ubicacion,
                            'comercial'     => (string)$dat->comercial,
                            'idRemoto'      => $dat->movimientoDetalle
                    );

                    print_r($data);

                    $this->db->insert('movimiento_detalle', $data);

                }

            }


        }

    }

    function cancela($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
    	$this->movimiento_model->cancelaMovimiento($movimientoID);
    	redirect('movimiento/index/' . $tipoMovimiento . '/' . $subtipoMovimiento);
    }

    function abrir($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
    	$this->movimiento_model->abrirMovimiento($movimientoID);
    	redirect('movimiento/index/' . $tipoMovimiento . '/' . $subtipoMovimiento);
    }

    function cerrar_sin_afectar($movimientoID, $tipoMovimiento, $subtipoMovimiento)
    {
        $this->movimiento_model->cerrarSinAfectar($movimientoID, $tipoMovimiento, $subtipoMovimiento);
        redirect('movimiento/index/' . $tipoMovimiento . '/' . $subtipoMovimiento);

    }

    function corrigeInv()
    {
        $sql = "SELECT * FROM kardex k where date(fechaKardex) = '2016-06-21' and subtipoMovimiento = 19 and clvsucursal = 12000 and cantidadOld > 0 and lote not in('B16M289', '147138', 'DH06415', '62214MC', '134372', 'V00616', 'VP00516', '130909', '128909', '76990', '131670', '135216', '604491', '129069', 'I16Y378', '360095', '1507391', 'Q016035', '5SM14', '124585', '180515', '9150093') group by id, lote;";

        $query = $this->db->query($sql);

        $cuenta = 1;

        foreach ($query->result() as $row) {
            
            $sql2 = "SELECT * FROM kardex k where date(fechaKardex) = '2016-06-21' and subtipoMovimiento = 19 and clvsucursal = 12000 and id = ? and lote = ? and cantidadOld > 0;";
            $query2 = $this->db->query($sql2, array($row->id, $row->lote));

            $sql3 = "SELECT * from inventario where clvsucursal = 12000 and id = ? and lote = ? and cantidad > 0 and ultimo_movimiento = ?;";
            $query3 = $this->db->query($sql3, array($row->id, $row->lote, $row->fechaKardex));

            if($query3->num_rows() == 0)
            {
                echo "<h1>$cuenta</h1>";
                echo "<pre>";
                print_r($query2->result());
                echo "</pre>";

                echo "<h3>Inventario</h3>";
                echo "<pre>";
                print_r($query3->result());
                echo "</pre>";

                $cuenta++;
            }



        }
    }

}