<?php
class Catalogosweb_model extends CI_Model {

    /**
     * Catalogos_model::__construct()
     * 
     * @return
     */
    function __construct()
    {
        parent::__construct();
    }
    
    function getCountArticulo($cvesuministro)
    {
        $sql = "SELECT count(*) as cuenta FROM articulos a where tipoprod = ?;";
        $query = $this->db->query($sql, $cvesuministro);
        $row = $query->row();
        
        return $row->cuenta;
    }

    function getCountEan()
    {
        $sql = "SELECT count(*) as cuenta FROM ean;";
        $query = $this->db->query($sql);
        $row = $query->row();
        
        return $row->cuenta;
    }

    function getArticulosFuera()
    {
        $sql = "SELECT id, cvearticulo, susa, descripcion, precioven, codigo, sales, activo, fecha_baja FROM articulo WHERE cuadro_id = 0 and precioven = 0 and id in(SELECT id FROM receta_detalle);";
        return $this->db->query($sql);
    }
    
    function insertaArticulo($data)
    {
        $this->db->db_debug = FALSE;
        $this->db->trans_start();
        $this->db->insert('articulos', $data);
        $id = $this->db->insert_id();
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE)
        {
            return 0;
        }else{
            return $id;
        }
        
    }
    
    function insertaArticulo2($data)
    {
        $this->db->db_debug = FALSE;
        $this->db->trans_start();
        $this->db->where('cvearticulo', $data->cvearticulo);
        $query = $this->db->get('articulos');
        $id = 0;
        if($query->num_rows() == 0)
        {
            $this->db->insert('articulos', $data);
            echo $this->db->last_query();
            $id = $this->db->insert_id();
        }
        
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE)
        {
            return 0;
        }else{
            return $id;
        }
        
    }

    function insertaArticulo3($data)
    {
        $this->db->where('cvearticulo', $data->cvearticulo);
        $query = $this->db->get('articulos');
        $id = 0;
        if($query->num_rows() == 0)
        {
            $this->db->insert('articulos', $data);
            $id = $this->db->insert_id();
        }
        
    }

    function insertarEan($ean, $comercial, $marca, $idArticulo)
    {

        $data = array('ean' => $ean, 'comercial' => $comercial, 'marca' => $marca, 'id' => $idArticulo);
        $this->db->insert('ean', $data);        

    }

    function getNuevoClaveArticulo()
    {
        $sql = "SELECT max(cvearticulo) + 1 as nuevo FROM `articulos`;";

        $query = $this->db->query($sql)->row();

        return $query->nuevo;
    }

    function insertarticulo($clave, $gobierno, $ean, $desc, $cronico, $grupo, $laboratorio, $presentacion, $susa, $restriccion, $unidad, $comercial, $precio, $tipoprod, $cuadro_id, $relacion_sal_id, $relacion_grupo_id, $sales,$antibiotico)
    {

        $cuadro = $this->getCuadroID($cuadro_id);

        if($cuadro->cuadro_id == 0)
        {
            $precio = $precio;
        }else{
            $precio = $cuadro->precio_unitario;
        }

        $query_sal = $this->getSalID($relacion_sal_id);

        if($query_sal->num_rows() > 0)
        {
            $sal = $query_sal->row();
            $susa = $sal->sal;
        }
        if($antibiotico)
        {
            $ant = 1;
        }else{
            $ant = 0;
        }

        $data = array('cvearticulo' => $clave, 'clave' => $gobierno, 'codigo' =>$ean, 'susa' => $susa, 'descripcion' => $desc, 'cronico' => $cronico, 'grupo'  => $grupo, 'presentacion_id' => $presentacion,  'restriccion_id' => $restriccion, 'unidad_id' => $unidad, 'precioven' => $precio, 'tipoprod' =>$tipoprod, 'laboratorio_id' => $laboratorio, 'cuadro_id' => $cuadro_id, 'relacion_sal_id' => $relacion_sal_id, 'relacion_grupo_id' => $relacion_grupo_id, 'antibiotico' => $ant);
        $this->db->insert('articulos', $data);

        $idarticulo = $this->db->insert_id();

        $this->insertarEan($ean, $comercial, null, $this->db->insert_id());
        if ($tipoprod = 0) {
            if ($sales) {
                foreach($sales as $numsal){
                    $data = array('id' => $idarticulo, 'relacion_sal_id' => $numsal);
                    $this->db->insert('articulos_compuesto', $data);
                }          
            }            
        }



    }

    function getCuadroID($cuadro_id)
    {
        $this->db->where('cuadro_id', $cuadro_id);
        $query = $this->db->get('cat_cuadro');

        return $query->row();
    }

    function getSalID($relacion_sal_id)
    {
        $this->db->where('relacion_sal_id', $relacion_sal_id);
        $query = $this->db->get('cat_relacional_sales');
        return $query;
    }

    function editaArticulo($idArticulo, $ean, $gobierno, $desc, $cronico, $grupo, $laboratorio, $presentacion, $susa, $restriccion, $unidad, $comercial, $precio, $tipoprod, $cuadro_id, $relacion_sal_id, $relacion_grupo_id, $sales,$antibiotico)
    {

        $cuadro = $this->getCuadroID($cuadro_id);

        if($cuadro->cuadro_id == 0)
        {
            $precio = $precio;
        }else{
            $precio = $cuadro->precio_unitario;
        }

        $query_sal = $this->getSalID($sales[0]);

        if($query_sal->num_rows() > 0)
        {
            $sal = $query_sal->row();
            $susa = $sal->sal;
        }
        
        if($antibiotico == 'on')
        {
            $ant = 1;
        }else{
            $ant = 0;
        }        

        $data = array('susa' => $susa, 'codigo' => $ean, 'clave' => $gobierno, 'descripcion' => $desc, 'cronico' => $cronico, 'grupo'  => $grupo, 'laboratorio_id' => $laboratorio, 'presentacion_id' => $presentacion, 'restriccion_id' => $restriccion, 'unidad_id' => $unidad, 'precioven' => $precio, 'tipoprod' => $tipoprod, 'cuadro_id' => $cuadro_id, 'relacion_sal_id' => $sales[0], 'relacion_grupo_id' => $relacion_grupo_id, 'antibiotico' => $ant);        
        $this->db->update('articulos', $data, array('id' => $idArticulo));
        if (strlen($ean)> 3 ) 
        {
            $sql = "SELECT * from ean where ean = $ean";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) 
            {
                $this->editaEan($ean, $comercial, null, $idArticulo);
            }else
            {
                $this->insertarEan($ean, $comercial, null, $idArticulo);
            }

        }
        $sql = "DELETE FROM articulos_compuesto WHERE id = $idArticulo;";
        $this->db->query($sql);
        if ($sales) {
            foreach($sales as $numsal){
                $data = array('id' => $idArticulo, 'relacion_sal_id' => $numsal);
                $this->db->insert('articulos_compuesto', $data);
            }            
        }
       


    }

    function editaEan($ean, $comercial, $marca, $idArticulo)
    {
        $data = array('comercial' => $comercial, 'marca' => $marca, 'id' => $idArticulo);        
        $this->db->update('ean', $data, array('ean' => $ean));          

    }    

    function insertaCliente($data)
    {
        $this->db->db_debug = FALSE;
        $this->db->trans_start();
        $this->db->insert('receptores', $data);
        $id = $this->db->insert_id();
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE)
        {
            return 0;
        }else{
            return $id;
        }
        
    }

    function getArticulo($idArticulo)
    {
        $sql = "SELECT a.*, e.ean, e.marca, e.comercial FROM articulos a 
            left JOIN ean e on a.codigo = e.ean
            WHERE a.id = $idArticulo";        
        $query = $this->db->query($sql);

        if($query->num_rows() > 0)
        {
            $row = $query->row();
            if ($row->activo == 1) {
                return $row;
            }else{
                return null;
            }            
        }else{
            return null;
        }

    }

    function addArticuloEntrada()
    {

        $this->db->trans_start();

        $cuadro_id = $this->input->post('cuadro_id');
        $relacion_sal_id = $this->input->post('relacion_sal_id');

        $this->db->insert('articulos', $_POST);

        $id = $this->db->insert_id();

        $cuadro = $this->getCuadroID($cuadro_id);

        if($cuadro->cuadro_id > 0)
        {
            $this->db->update('articulos', array('precioven' => $cuadro->precio_unitario), array('id' => $id));
        }

        $query_sal = $this->getSalID($relacion_sal_id);

        if($query_sal->num_rows() > 0)
        {
            $sal = $query_sal->row();
            $this->db->update('articulos', array('susa' => $sal->sal), array('id' => $id));
        }

        $this->db->trans_complete();

        if($this->db->trans_status() === FALSE){
            return array('error' => 'No se pudo agregar.');
        }else{
            return $this->getArticuloID($id);
        }

}

    function getClaveArticuloNuevo()
    {
        $c = $this->getNuevoClaveArticulo();
        return array('nuevo' => $c);
    }

    function getArticuloID($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('articulos')->row();
    }

    function getEan($ean)
    {
        $sql ="SELECT id, codigo, activo, cvearticulo, susa, descripcion FROM articulos                   
                where codigo = $ean and activo = 1";     
        $query = $this->db->query($sql);

        if($query->num_rows() > 0)
        {
            $row = $query->row();
            if ($row->activo == 1) {
                return $row;
            }else{
                return array('not_found' => true);
            }            
        }else{
            return array('not_found' => true);
        }

    } 

    function getBuscaArticuloByClave($term)
    {
        $this->db->where('cvearticulo', $term);
        $query = $this->db->get('articulos');        
        if($query->num_rows() == 0)
        {
            return false;
        }
        else{
            return true;
        }
    }

    function getBuscaArticuloByEan($term)
    {
        $this->db->where('clave', $term);
        $query = $this->db->get('articulos');        
        if($query->num_rows() == 0)
        {
            return false;
        }
        else{

            return true;
        }
    }    

    function getBuscaEanByEan($term)
    {
        $this->db->where('ean', $term);
        $query = $this->db->get('ean');
              
        if($query->num_rows() == 0)
        {
            return false;
        }
        else{           
            return $query->result();
        }
    }    

    function getInventarioExportar()
    {
        $this->db->where_not_in('cantidad', array(0));
        $query = $this->db->get('inventario');
        
        $a = array();
        
        foreach($query->result() as $row)
        {
            array_push($a, $row);
        }
        
        return $a;
    }
    
    function getKardexExportar($fecha1, $fecha2)
    {
        $this->db->where('fechaKardex >=', $fecha1.' 00:00:00');
        $this->db->where('fechaKardex <=', $fecha2.' 23:59:59');
        $query = $this->db->get('kardex');
        
        $a = array();
        
        foreach($query->result() as $row)
        {
            array_push($a, $row);
        }
        
        return $a;
    }
    
    function getMovimientoExportar($fecha1, $fecha2)
    {
        $this->db->where('fechaCierre >=', $fecha1.' 00:00:00');
        $this->db->where('fechaCierre <=', $fecha2.' 23:59:59');
        $this->db->where('statusMovimiento', 1);
        $query = $this->db->get('movimiento');
        
        $a = array();
        
        foreach($query->result() as $row)
        {
            array_push($a, $row);
        }
        
        return $a;
    }

    function getMovimientoDetalleExportar($fecha1, $fecha2)
    {
        $this->db->select('d.*');
        $this->db->from('movimiento c');
        $this->db->join('movimiento_detalle d', 'c.movimientoID = d.movimientoID');
        $this->db->where('c.fechaCierre >=', $fecha1.' 00:00:00');
        $this->db->where('c.fechaCierre <=', $fecha2.' 23:59:59');
        $this->db->where('c.statusMovimiento', 1);
        $query = $this->db->get();
        
        $a = array();
        
        foreach($query->result() as $row)
        {
            array_push($a, $row);
        }
        
        return $a;
    }
    
    function getDomicilio()
    {
        $this->db->where('idDomicilio', 1);
        $query = $this->db->get('sucursal_domicilio');
        
        return $query;
    }
    
    function getContrato($rfc)
    {
        $this->db->from('contrato c');
        $this->db->where('c.rfc', $rfc);
        $this->db->join('receptores r', 'c.rfc = r.rfc');
        $query = $this->db->get();
        
        return $query;
    }
    
    function getContratoByContratoID($contratoID)
    {
        $this->db->from('contrato c');
        $this->db->where('c.contratoID', $contratoID);
        $this->db->join('receptores r', 'c.rfc = r.rfc');
        $query = $this->db->get();
        
        return $query;
    }

    function insertContrato($rfc, $numero, $denominado)
    {
        $data = array('rfc' => $rfc, 'numero' => $numero, 'denominado' => strtoupper($denominado));
        $this->db->insert('contrato', $data);
    }
    
    function updateContrato($contratoID, $numero, $denominado, $referencia_factura)
    {
        $data = array('numero' => $numero, 'denominado' => strtoupper($denominado), 'referencia_factura' => $referencia_factura);
        $this->db->update('contrato', $data, array('contratoID' => $contratoID));
    }
    
    function insertaArticuloContratoPrecio($contratoID)
    {
        $sql = "insert ignore contrato_precio (contratoID, id)(SELECT ?, id FROM articulos);";
        $this->db->query($sql, $contratoID);
    }
    
    function getContratoPrecioByContratoID($contratoID)
    {
        $sql = "SELECT * FROM contrato_precio c
join articulos a using(id)
where contratoID = ?
order by cvearticulo * 1;";

        $query = $this->db->query($sql, $contratoID);
        
        return $query;
    }
    
    function saveContratoPrecio($contratoPrecioID, $precioContrato)
    {
        $data = array('precioContrato' => $precioContrato);
        $this->db->update('contrato_precio', $data, array('contratoPrecioID' => $contratoPrecioID));
    }
    
    function getSucursalesCliente($rfc)
    {
        $sql = "SELECT * FROM receptores_sucursal r
join receptores e using(rfc)
join sucursales s using(clvsucursal)
where rfc = ?;";

        $query = $this->db->query($sql, (string)$rfc);
        
        return $query;
    }
    
    function insertSucursalCliente($rfc, $clvsucursal)
    {
        $data = array('rfc' => $rfc, 'clvsucursal' => $clvsucursal);
        
        $this->db->where('rfc', $rfc);
        $this->db->where('clvsucursal', $clvsucursal);
        $query = $this->db->get('receptores_sucursal');
        
        $this->db->where('clvsucursal', $clvsucursal);
        $query2 = $this->db->get('sucursales');
        
        if($query->num_rows() == 0 && $query2->num_rows() > 0)
        {
            $this->db->insert('receptores_sucursal', $data);
        }
        
        
    }
    
    function insertSucursalCliente2($rfc, $clvsucursal1, $clvsucursal2)
    {
        for($i = $clvsucursal1; $i<= $clvsucursal2; $i++)
        {
            $this->insertSucursalCliente($rfc, $i);
        }
    }
    
    function eliminaReceptorSucursalID($receptorSucursalID)
    {
        $this->db->delete('receptores_sucursal', array('receptorSucursalID' => $receptorSucursalID));
    }

    function getMovimientoEmbarqueExportar($fecha1, $fecha2)
    {
        $this->db->select('d.*');
        $this->db->from('movimiento c');
        $this->db->join('movimiento_embarque d', 'c.movimientoID = d.movimientoID');
        $this->db->where('c.fechaCierre >=', $fecha1.' 00:00:00');
        $this->db->where('c.fechaCierre <=', $fecha2.' 23:59:59');
        $this->db->where('c.statusMovimiento', 1);
        $query = $this->db->get();
        
        $a = array();
        
        foreach($query->result() as $row)
        {
            array_push($a, $row);
        }
        
        return $a;
    }

    function getRecetaExportar($fecha1, $fecha2)
    {
        $fecha1 = $fecha1. " 00:00:00";
        $fecha2 = $fecha2. " 23:59:59";

        $sql = "SELECT * FROM receta r where (alta between ? and ?) or (cambio between ? and ?);";
        $query = $this->db->query($sql, array($fecha1, $fecha2, $fecha1, $fecha2));
        
        $a = array();
        
        foreach($query->result() as $row)
        {
            array_push($a, $row);
        }
        
        return $a;
    }

    function getRecetaDetalleExportar($fecha1, $fecha2)
    {
        $fecha1 = $fecha1. " 00:00:00";
        $fecha2 = $fecha2. " 23:59:59";

        $sql = "SELECT d.* FROM receta r join receta_detalle d using(consecutivo) where (alta between ? and ?) or (cambio between ? and ?);";
        $query = $this->db->query($sql, array($fecha1, $fecha2, $fecha1, $fecha2));
        
        $a = array();
        
        foreach($query->result() as $row)
        {
            array_push($a, $row);
        }
        
        return $a;
    }
    
    function getProveedorExportar()
    {
        $sql = "SELECT proveedorID, rfc, razon, ".$this->session->userdata('clvsucursal')." as clvsucursal FROM proveedor p;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            array_push($a, $row);
        }
        
        return $a;
    }

    function activaArticulo($idArticulo)
    {
        $data = array('activo' => 1);
        $this->db->update('articulos', $data, array('id' => $idArticulo));        
    } 

    function desactivaArticulo($idArticulo)
    {
        $data = array('activo' => 0, 'fecha_baja' => date('Y-m-d'));
        $this->db->update('articulos', $data, array('id' => $idArticulo));        
    } 

    function activaEan($ean)
    {
        $data = array('activo' => 1);
        $this->db->update('ean', $data, array('ean' => $ean));        
    } 

    function desactivaEan($ean)
    {
        $data = array('activo' => 0, 'fecha_baja' => date('Y-m-d'));
        $this->db->update('ean', $data, array('ean' => $ean));        
    } 


    function getDevolucionExportar($fecha1, $fecha2)
    {
        $fecha1 = $fecha1. " 00:00:00";
        $fecha2 = $fecha2. " 23:59:59";

        $sql = "SELECT * FROM devolucion where fechaDevolucion between ? and ?;";
        $query = $this->db->query($sql, array($fecha1, $fecha2));
        
        $a = array();
        
        foreach($query->result() as $row)
        {
            array_push($a, $row);
        }
        
        return $a;
    }

    function getArticulos($cvesuministro)
    {
        $sql = "SELECT suministro, id, antibiotico, semaforo, semaforoDescripcion, semaforoColor, cvearticulo, susa, descripcion, pres, case when ventaxuni = 0 then 'NO' else 'SI' end as ventaxuni, numunidades FROM articulos a
join temporal_suministro s on a.tipoprod = s.cvesuministro
join semaforo o using(semaforo)
where tipoprod = ?
order by tipoprod, cvearticulo * 1
limit 500;";
        
        return $this->db->query($sql, $cvesuministro);
    }

    function getEanLimit($limit, $offset = 0)
    {
        $sql = "SELECT e.*, cvearticulo, descripcion, suministro FROM ean e
            join articulos a on e.id = a.id
            join temporal_suministro s on a.tipoprod = s.cvesuministro                        
            order by tipoprod, id
            limit ? offset ?;";
        
        return $this->db->query($sql, array($limit, (int)$offset));
    }
    
    function getArticulosLimit($cvesuministro, $limit, $offset = 0)
    {
        $sql = "SELECT suministro, id, antibiotico, cause, semaforo, semaforoDescripcion, semaforoColor, cvearticulo, susa, precioven, c.sal, codigo, activo,  fecha_baja, descripcion, pres, case when ventaxuni = 0 then 'NO' else 'SI' end as ventaxuni, numunidades FROM articulos a
            join temporal_suministro s on a.tipoprod = s.cvesuministro
            join semaforo o using(semaforo)
            join cat_cuadro c using(cuadro_id)
            where tipoprod = ?
            order by tipoprod, id
            limit ? offset ?;";
        
        return $this->db->query($sql, array($cvesuministro, $limit, (int)$offset));
    }

    function getArticulosCobertura()
    {
        $sql = "SELECT id, cvearticulo, clave, susa, descripcion, pres, GROUP_CONCAT(programa) as programa, cause, antibiotico, semaforo, semaforoDescripcion, semaforoColor
FROM articulos a
join semaforo o using(semaforo)
join articulos_cobertura c using (id)
join programa p using(idprograma)
where nivelatencion = ?
group by id
order by tipoprod, cvearticulo * 1;";
        
        return $this->db->query($sql, array($this->session->userdata('nivelAtencion')));
    }

    function getClientes()
    {
        $sql = "SELECT * from receptores order by razon;";
        
        return $this->db->query($sql);
    }

    function getProveedor()
    {
        $this->db->where_not_in('proveedorID', array(1));
        $query = $this->db->get('proveedor');
        return $query;
    }
    
    function getProveedorOrigen()
    {
        $query = $this->db->get('proveedor_origen');
        return $query;
    }

    function getProveedorID()
    {
        $sql = "SELECT ifnull(max(proveedorID) + 1, 0) as proveedorID FROM proveedor p where proveedorID >= 10000;";
        $query = $this->db->query($sql);
        
        $row = $query->row();
        
        if($row->proveedorID == 0)
        {
            return 10000;
        }else{
            return $row->proveedorID;
        }
    }
    
    function insertProveedor($rfc, $razon, $proveedorID)
    {
        $this->db->where('rfc', $rfc);
        $query = $this->db->get('proveedor');
        
        if($query->num_rows() == 0)
        {
            if($proveedorID == 0)
            {
                $proveedorID = $this->getProveedorID();
            }else{
                
            }
            $data = array('rfc' => strtoupper($rfc), 'razon' => strtoupper($razon), 'proveedorID' => $proveedorID);
            $this->db->insert('proveedor', $data);
        }else{
            
        }
    }
    
    function insertProveedorOrigen($rfcOrigen, $razonOrigen)
    {
        $this->db->where('rfcOrigen', $rfcOrigen);
        $query = $this->db->get('proveedor_origen');
        
        if($query->num_rows() == 0)
        {
            $data = array('rfcOrigen' => strtoupper($rfcOrigen), 'razonOrigen' => strtoupper($razonOrigen));
            $this->db->insert('proveedor_origen', $data);
        }
    }

    function getProveedorByID($proveedorID)
    {
        $this->db->where('proveedorID', $proveedorID);
        $query = $this->db->get('proveedor');
        return $query;
    }
    
    function getProveedorOrigenByID($proveedorOrigenID)
    {
        $this->db->where('proveedorOrigenID', $proveedorOrigenID);
        $query = $this->db->get('proveedor_origen');
        return $query;
    }

    function getJsonProveedor()
    {
        $json = null;
        $ctx = stream_context_create(array('http'=>
            array(
                'timeout' => 5, // 1 200 Seconds = 20 Minutes
            )
        ));
        if($json = file_get_contents('http://192.168.1.220/oficinas/api/proveedor', false, $ctx))
        {
            if(strlen($json) == 0)
            {
                $json = file_get_contents('http://189.203.201.166/oficinas/api/proveedor');
            }
        }
        
        
        return $json;
    }
    

    function actualizaProveedor($rfc, $razon, $proveedorID)
    {
        $data = array('rfc' => strtoupper($rfc), 'razon' => strtoupper($razon));
        $this->db->update('proveedor', $data, array('proveedorID' => $proveedorID));
    }

    function actualizaProveedorOrigen($rfcOrigen, $razonOrigen, $proveedorOrigenID)
    {
        $data = array('rfcOrigen' => strtoupper($rfcOrigen), 'razonOrigen' => strtoupper($razonOrigen));
        $this->db->update('proveedor_origen', $data, array('proveedorOrigenID' => $proveedorOrigenID));
    }

    function getSucursal()
    {
        $sql = "SELECT * FROM sucursales s
join dia d on s.diaped = d.dia
join jurisdiccion j using(numjurisd)
join temporal_nivel_atencion n using(nivelAtencion)
join sucursales_tipo t using(tiposucursal)
where activa = 1
order by numjurisd, clvsucursal;";

        $query = $this->db->query($sql);
        return $query;
    }

    function insertSucursal($clvsucursal, $descsucursal, $numjurisd)
    {
        $this->db->where('clvsucursal', $clvsucursal);
        $query = $this->db->get('sucursales');
        
        if($query->num_rows() == 0)
        {
            $data = array('clvsucursal' => $clvsucursal, 'descsucursal' => $descsucursal, 'numjurisd' => $numjurisd);
            $this->db->insert('sucursales', $data);
        }else{
            
        }
    }
    
    function getSucursalByClvsucursal($clvsucursal)
    {
        $this->db->where('clvsucursal', $clvsucursal);
        $query = $this->db->get('sucursales');
        return $query;
    }
    
    function getSucursalExtByClvsucursal($clvsucursal)
    {
        $this->db->where('clvsucursal', $clvsucursal);
        $query = $this->db->get('sucursales_ext');
        return $query;
    }

    function actualizaSucursal($clvsucursal, $numjurisd, $nombreSucursalPersonalizado, $domicilioSucursalPersonalizado)
    {
        $data = array('clvsucursal' => $clvsucursal, 'nombreSucursalPersonalizado' => $nombreSucursalPersonalizado, 'domicilioSucursalPersonalizado' => $domicilioSucursalPersonalizado);
        $this->db->replace('sucursales_ext', $data);
    }

    function getUsuario()
    {
        $sql = "SELECT usuario, clvusuario, password, nombreusuario, case when estaactivo = 0 then 'INACTIVO' else 'ACTIVO' end as estaactivo, descsucursal, puesto
FROM usuarios u
join sucursales s using(clvsucursal)
join puesto p using(clvpuesto);";
        $query = $this->db->query($sql);
        return $query;
        
    }

    function insertUsuario($clvusuario, $password, $nombreusuario, $clvsucursal, $clvpuesto, $estaactivo)
    {
        $this->db->where('clvusuario', $clvusuario);
        $query = $this->db->get('usuarios');
        
        if($query->num_rows() == 0)
        {
            $data = array('clvusuario' => $clvusuario, 'password' => $password, 'nombreusuario' => $nombreusuario, 'clvsucursal' => $clvsucursal, 'clvpuesto' => $clvpuesto, 'estaactivo' => $estaactivo);
            $this->db->insert('usuarios', $data);
        }else{
            
        }
    }
    
    function getUsuarioByUsuario($usuario)
    {
        $this->db->where('usuario', $usuario);
        $query = $this->db->get('usuarios');
        return $query;
    }

    function actualizaUsuario($clvusuario, $password, $nombreusuario, $clvsucursal, $clvpuesto, $estaactivo, $usuario)
    {
        $data = array('clvusuario' => $clvusuario, 'password' => $password, 'nombreusuario' => $nombreusuario, 'clvsucursal' => $clvsucursal, 'clvpuesto' => $clvpuesto, 'estaactivo' => $estaactivo);
        $this->db->update('usuarios', $data, array('usuario' => $usuario));
    }

    function limpia($in)
    {
        $out = str_replace("'", "", $in);
        return $out;
    }

    function getArticuloForStandAlone()
    {
        $sql = "SELECT id, cvearticulo, susa, descripcion, pres, precioven, numunidades, tipoprod
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 1 and idprograma = 0) is not null then 1 else 0 end as pa
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 1 and idprograma = 1) is not null then 1 else 0 end as sp
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 1 and idprograma = 2) is not null then 1 else 0 end as op
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 1 and idprograma = 3) is not null then 1 else 0 end as pp
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 1 and idprograma = 4) is not null then 1 else 0 end as bp
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 1 and idprograma = 5) is not null then 1 else 0 end as am
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 1 and idprograma = 6) is not null then 1 else 0 end as pq
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 1 and idprograma = 7) is not null then 1 else 0 end as sm
FROM articulos a
;
;";
        $query =  $this->db->query($sql);
        
        $data = "delete from articulo;\r\n";
        
        foreach($query->result() as $row)
        {
            $clave = $this->limpia(trim($row->cvearticulo));
            $sustancia = $this->limpia(trim($row->susa));
            $descripcion = $this->limpia(trim($row->descripcion));
            $presentacion = $this->limpia(trim($row->pres));
            $data .= utf8_decode("insert into articulo (clave, sustancia, descripcion, presentacion, precioUnitario, unidades, pa, sp, op, pp, bp, am, pq, sm, tipoArticulo, idArticulo) values('$clave', '$sustancia', '$descripcion', '$presentacion', $row->precioven, $row->numunidades, $row->pa, $row->sp, $row->op, $row->pp, $row->bp, $row->am, $row->pq, $row->sm, $row->tipoprod, $row->id);\r\n");
        }
        
        return $data;
        
    }

    function getArticuloForStandAlone2()
    {
        $sql = "SELECT id, cvearticulo, susa, descripcion, pres, precioven, numunidades, tipoprod
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 2 and idprograma = 0) is not null then 1 else 0 end as pa
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 2 and idprograma = 1) is not null then 1 else 0 end as sp
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 2 and idprograma = 2) is not null then 1 else 0 end as op
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 2 and idprograma = 3) is not null then 1 else 0 end as pp
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 2 and idprograma = 4) is not null then 1 else 0 end as bp
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 2 and idprograma = 5) is not null then 1 else 0 end as am
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 2 and idprograma = 6) is not null then 1 else 0 end as pq
, case when (select idprograma from articulos_cobertura c where a.id = c.id and nivelatencion = 2 and idprograma = 7) is not null then 1 else 0 end as sm
FROM articulos a
;
;";
        $query =  $this->db->query($sql);
        
        $data = "delete from articulo;\r\n";
        
        foreach($query->result() as $row)
        {
            $clave = $this->limpia(trim($row->cvearticulo));
            $sustancia = $this->limpia(trim($row->susa));
            $descripcion = $this->limpia(trim($row->descripcion));
            $presentacion = $this->limpia(trim($row->pres));
            $data .= utf8_decode("insert into articulo (clave, sustancia, descripcion, presentacion, precioUnitario, unidades, pa, sp, op, pp, bp, am, pq, sm, tipoArticulo, idArticulo) values('$clave', '$sustancia', '$descripcion', '$presentacion', $row->precioven, $row->numunidades, $row->pa, $row->sp, $row->op, $row->pp, $row->bp, $row->am, $row->pq, $row->sm, $row->tipoprod, $row->id);\r\n");
        }
        
        return $data;
        
    }

    function getSucursalForStandAlone()
    {
        $sql = "SELECT clvsucursal, descsucursal FROM sucursales s where activa = 1 and tiposucursal not in(0, 4);";
        $query =  $this->db->query($sql);
        
        $data = "";
        
        foreach($query->result() as $row)
        {
            $suc = trim($row->clvsucursal);
            $sucursal = trim($row->descsucursal);
            $data .= "replace into sucursal (suc, sucursal) values('$suc', '$sucursal');\r\n";
        }
        
        return $data;
        
    }

    function getUsuarioForStandAlone()
    {
        $sql = "SELECT clvsucursal, descsucursal FROM sucursales s where activa = 1 and tiposucursal not in(0, 4);";
        $query =  $this->db->query($sql);
        
        $data = "";
        
        foreach($query->result() as $row)
        {
            $suc = trim($row->clvsucursal);
            $sucursal = trim($row->descsucursal);
            $data .= "replace into usuario (idUsuario, usuario, password, nombreUsuario, activo, suc) values($suc, '$suc', '$suc', '$sucursal', 1, $suc);\r\n";
        }
        
        return $data;
        
    }

    function getCronico()
    {
        $sql = "SELECT * FROM cat_cronico;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            $a[$row->cronico] = $row->cronico_descripcion;            
        }
        
        return $a;
    } 

    function getGrupo()
    {
        $sql = "SELECT * FROM cat_grupo;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            $a[$row->grupo] = $row->grupo_descripcion;
        }
        
        return $a;
    }

    function getLaboratorio()
    {
        $sql = "SELECT * FROM cat_laboratorio order by laboratorio;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            $a[$row->laboratorio_id] = $row->laboratorio;
        }
        
        return $a;
    }

    function getPresentacion()
    {
        $sql = "SELECT * FROM cat_presentacion;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            $a[$row->presentacion_id] = $row->presentacion;
        }
        
        return $a;
    }

    function getRelacional()
    {
        $sql = "SELECT * FROM cat_relacional_sales;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            $a[$row->sal] = $row->sal;
        }
        
        return $a;
    } 

    function getRestriccion()
    {
        $sql = "SELECT * FROM cat_restriccion;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            $a[$row->restriccion_id] = $row->restriccion;
        }
        
        return $a;
    }     

    function getUnidad()
    {
        $sql = "SELECT * FROM cat_unidad;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            $a[$row->unidad_id] = $row->unidad;
        }
        
        return $a;
    }

    function getCuadro()
    {
        $sql = "SELECT * FROM cat_cuadro order by sal, concentracion, presentacion, envasado_en;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            $a[$row->cuadro_id] = $row->sal . ' ' . $row->concentracion . ' ' . $row->presentacion . ' ' . $row->envasado_en;
        }
        
        return $a;
    }

    function getRelacionalGrupo()
    {
        $sql = "SELECT * FROM cat_relacional_grupos order by relacion_grupo_id;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            $a[$row->relacion_grupo_id] = $row->relacion_grupo_descripcion;
        }
        
        return $a;
    }

    function getRelacionArticuloSal($idArticulo)
    {
        $sql = "SELECT a.id, a.relacion_sal_id, c.sal FROM articulos_compuesto a
        JOIN cat_relacional_sales c using(relacion_sal_id)
        WHERE id = $idArticulo;";
        $query = $this->db->query($sql);
        return $query;
    }

    function getRelacionalSal()
    {
        $sql = "SELECT * FROM cat_relacional_sales order by sal;";
        $query = $this->db->query($sql);
        
        $a = array();
        foreach($query->result() as $row)
        {
            $a[$row->relacion_sal_id] = $row->sal;
        }
        
        return $a;
    }
}