<script type="text/javascript">

var folioreceta = null;

$(document).on("ready", inicio);

$(document).keydown(function(event) 
{
	if (event.keyCode == 115)
	{
		$("#guardar").click();
	}
});

function inicio() {
	detalle();
	folioreceta = $("#folioreceta").val().trim();
}

$("#form_folioreceta").on("submit", validaFolio);
$("#folioreceta").on("change", validaFolio);

function validaFolio(e) {

	e.preventDefault();

	folioreceta = $("#folioreceta").val().trim();

	var $url = '<?php echo site_url('captura/valida_folio_rapido'); ?>';
	var $variables = { folioreceta : folioreceta };
	var posting = $.post( $url, $variables );

	posting.done(function( data ) {

		obj = jQuery.parseJSON(data);

		if(obj.return == 0)
		{
			$("#codigo").focus();
		}else{
			alert("Este folio ya esta capturado.");
			$("#folioreceta").val(null).focus();
		}

	});

}

$("#form_codigo").on("submit", validaCodigo);

function validaCodigo(e) {

	e.preventDefault();

	codigo = $("#codigo").val();

	var $url = '<?php echo site_url('captura/valida_codigo_rapido'); ?>';
	var $variables = { codigo : codigo };
	var posting = $.post( $url, $variables );

	posting.done(function( data ) {

		detalle();

		$("#codigo").val(null).focus();

	});

}

function detalle() {

	var $url = '<?php echo site_url('captura/get_detalle_rapida'); ?>';
	var $variables = { };
	var posting = $.post( $url, $variables );

	posting.done(function( data ) {

		$("#detalle").html(data);

	});
}

$("#detalle").on("click", ".eliminar", eliminar);

function eliminar(e) {
	e.preventDefault();

	if(!confirm("¿ Seguro que deseas eliminar este registro ?")) {
		return false;
	}

	var serie = $(this).data("serie");

	var $url = '<?php echo site_url('captura/delete_detalle_rapida'); ?>';
	var $variables = { serie: serie };
	var posting = $.post( $url, $variables );

	posting.done(function( data ) {

		detalle();
		$("#codigo").val(null).focus();

	});
}

$("#guardar").on("click", guardar);

function guardar(e) {
	e.preventDefault();

	var sur = parseInt($("#sur").html());

	if(sur == 0) {
		alert("No hay productos por guardar.");
		return false;
	}

	if(folioreceta == null || folioreceta.length == 0)
	{
		alert("El folio de la receta no puede ir vacio.");
		return false;
	}
	
	if(!confirm("¿ Seguro que deseas guardar ?")) {
		return false;
	}

	var $url = '<?php echo site_url('captura/guarda_fast'); ?>';
	var $variables = { folioreceta: folioreceta };
	var posting = $.post( $url, $variables );

	posting.done(function( data ) {

		obj = jQuery.parseJSON(data);

		if(obj.return == false)
		{
			alert("Error en receta. Volver a intentar.");
		}else{
			ultima(obj.return);
		}

		detalle();
		$("#codigo").val(null);
		$("#folioreceta").val(null).focus();

	});	
}

function ultima(consecutivo) {

	var $url = '<?php echo site_url('captura/fast_ultima'); ?>';
	var $variables = { consecutivo: consecutivo };
	var posting = $.post( $url, $variables );

	posting.done(function( data ) {
		$("#ultima").prepend(data);
	});
}


</script>